$(document).ready(function() {
   var window_width = jQuery(window).width();
    var device_layout;
    if(window_width <= 767){
        device_layout = "mobile";
        // alert(device_layout);
        $('.table_view').removeClass('appendData');
        $('.mobile_view').addClass('appendData');
        $('#view_type').val('mobile');
    }
    else
    {
        $('.table_view').addClass('appendData');
        $('.mobile_view').removeClass('appendData');
        $('#view_type').val('desktop');
    }
   var baseurl  = $('#geturl').val();
   function loadMore(category_id,view_type)
   {
        $(window).bind('scroll');    
        if(category_id !=0)
        {
            var lastnum  = $('.lastnum').val();
            // alert(lastnum);
            $.ajax({
                method: 'POST',
                data: {
                    'category_id'   : category_id,
                    'view_type'   : view_type,
                    'lastnum'   : lastnum,
                },
                url  : baseurl+'/order/getItems',
                dataType: 'json',
            }).done(function (response) {
                $('.loading').remove();
                if(response.status == 1)
                {
                    var data = response.data;
                    if(data.length != 0)
                    {
                        $('.appendData').append(data);
                        $('#category_id').val(response.next_id);
                        $('.lastnum').val(response.lastnum);
                        $(window).bind('scroll', bindScroll);
                    }
                    else
                    {
                        $('#category_id').val(0);
                    }
                }
                else
                {
                    $('#category_id').val(0);
                }
            });
        }
   }

    function bindScroll(){
       if($(window).scrollTop() + $(window).height() > $(document).height() - 500) {
           $(window).unbind('scroll');
           var category_id  = $('#category_id').val();
           var view_type  = $('#view_type').val();
           loadMore(category_id,view_type);
       }
    }
    
    // $(document.body).on('touchmove', bindScroll);
    $(window).scroll(bindScroll);
    
    $(document).on('click','.addtocart',function(){
        var thisval =$(this);
        var id =$(this).attr('data-id');
        // var price =$(this).attr('data-price');
        var qty = $(this).parent().parent().find('.qty-select').val();
        
        $.ajax({
            method: 'POST',
            data: {
                'qty'  : qty,
                'id'   : id,
            },
            url  : baseurl+'/order/addCartItems',
            dataType: 'json',
        }).done(function (response) {
            if(response.status == 1)
            {
                thisval.empty().html('Added');
                var data = response.data;
                $('.cart_count').html(data[0]['total_cart']);
                $('#snackbar').empty().html('<i class="feather-icon icon-check-circle"></i> Card item added successfully');
                $("#snackbar").addClass('show'); 
                setTimeout(function(){
                    $("#snackbar").removeClass('show'); 
                    }, 3000);
                // $('.product_count').html(data[0]['total_qty']);
                // $('.discount_total').html(data[0]['total_dis']);
                // $('.overall_total').html(data[0]['total_amount']);
                // $('.net_total').html(data[0]['total_unitprice']);
            }
            else
            {
                $('.cart_count').html(0);
                // $('.product_count').html(0);
                // $('.discount_total').html(0);
                // $('.overall_total').html(0);
                // $('.net_total').html(0);
            }
        });
            
        
    });
    $(document).on('change','.qtychange',function(){
        var thisval =$(this);
        var id =$(this).attr('data-id');
        var price =$(this).attr('data-price');
        var qty = $(this).val();
        
        $.ajax({
            method: 'POST',
            data: {
                'qty'  : qty,
                'id'   : id,
            },
            url  : baseurl+'/order/addCartItems',
            dataType: 'json',
        }).done(function (response) {
            if(response.status == 1)
            {
                var data = response.data;
                var rate_box = qty * price;
                
                $('#snackbar').empty().html('<i class="feather-icon icon-check-circle"></i> Cart item update successfully');
                $("#snackbar").addClass('show'); 
                setTimeout(function(){ 
                    $("#snackbar").removeClass('show'); 
                 }, 3000);
                thisval.parent().parent().parent().find('.rate_box_html').html(rate_box);
                $('.cart_count').html(data[0]['total_cart']);
                totalcart();
            }
            else
            {
                thisval.parent().parent().parent().find('.rate_box_html').html(0);
                $('.cart_count').html(0);
            }
        });
            
        
    });
   function totalcart()
   {
        $.ajax({
            method: 'POST',
            data: {},
            url  : baseurl+'/order/cartTotalDetails',
            dataType: 'json',
        }).done(function (response) {
            if(response.status == 1)
            {
                var data = response.data;
                $('.cart_count').html(data[0]['total_cart']);
                // $('.product_count').html(data[0]['total_qty']);
                $('.discount_total').html(data[0]['total_dis']);
                $('.overall_total').html(data[0]['total_amount']);
                $('.net_total').html(data[0]['total_unitprice']);
                if(data[0]['total_amount'] <=0)
                {
                    $('.continue_order').addClass('d-none');
                    $('.addresspage').addClass('d-none');
                    $('.continue_error').removeClass('d-none');   
                }
            }
            else
            {
                $('.cart_count').html(0);
                // $('.product_count').html(0);
                $('.discount_total').html(0);
                $('.overall_total').html(0);
                $('.net_total').html(0);
                $('.continue_order').addClass('d-none');
                $('.addresspage').addClass('d-none');
            }
        });
   }
   totalcart();
   $(document).on('click','.cartBtn',function(){
        $.ajax({
            method: 'POST',
            data: {},
            url  : baseurl+'/order/getCartItems',
            dataType: 'json',
        }).done(function (response) {
            if(response.status == 1)
            {
                var data = response.data;
                $('.cartItems').html(data);
                $('.minimum_order').val(response.minimum_order);
                $('.continue_order').removeClass('d-none');
                if(data =='')
                {
                    $('.minimum_order').val(0);
                    $('.continue_order').addClass('d-none');
                } 
                totalcart();
            }
            else
            {
                $('.minimum_order').val(0);
                $('.cartItems').html('');
                $('.continue_order').addClass('d-none');
            }
        });
    });
   $(document).on('click','.deleteCart',function(){
        var thisval =$(this);
        var id =$(this).attr('data-id');
        $.ajax({
            method: 'POST',
            data: {
                'id':id
            },
            url  : baseurl+'/order/deleteCart',
            dataType: 'json',
        }).done(function (response) {
            $('#snackbar').empty().html('<i class="feather-icon icon-check-circle"></i> Cart item removed successfully');
            $("#snackbar").addClass('show'); 
            setTimeout(function(){
                $("#snackbar").removeClass('show'); 
                }, 3000);
            thisval.parent().parent().parent().parent().parent().parent().remove();
            totalcart();
        });
    });
   $(document).on('click','.continue_order',function(){
        var total = $('.overall_total').html();
        var minimum_order = $('.minimum_order').val();
        if(parseFloat(total) >= parseFloat(minimum_order))
        {
            $('.continue_order').addClass('d-none');
            $('.continue_error').addClass('d-none');
            $('.addresspage').removeClass('d-none');
            window.location = baseurl+"/checkout";
        }
        else
        {
            $('.continue_error').removeClass('d-none');
            $('.continue_error').html('Minimum Order value greater then '+minimum_order+' rupees!');
        }
        

   });
   $(document).on('input','.digitval', function (event) { 
        this.value = this.value.replace(/[^0-9.]/g, '');
    });
    $(document).on('input','.albhaSpace', function (event) { 
        this.value = this.value.replace(/[^a-zA-Z\s]/g, '');
    });
    
    $(document).on('click','.closeBtn', function (event) { 
        window.location.reload();
    });
    $(document).on('keyup','.form_val',function(){
        var value = $(this).data('value');
        $('.'+value+'_error').removeClass('d-block').addClass('d-none');
        $('.common_error').removeClass('d-block').addClass('d-none');
        // $('.'+value).removeClass('error_alert');
    });

    $(document).on('change','.form_val',function(){
        var value = $(this).data('value');
        $('.'+value+'_error').removeClass('d-block').addClass('d-none');
        $('.common_error').removeClass('d-block').addClass('d-none');

        // $('.'+value).removeClass('error_alert');
    });
    function loadOn()
    {
        $('.loadingBtn').removeClass('d-none');
        $('.subBtn').addClass('d-none');
    }
    function loadOff()
    {
        $('.loadingBtn').addClass('d-none');
    }
    function eloadOff()
    {
        $('.loadingBtn').addClass('d-none');
        $('.subBtn').removeClass('d-none');
    }
    // Insert
    $('.insert_data').on('submit', function(e) {
        e.preventDefault();
        loadOn();
        var total = $('.overall_total').html();
        var minimum_order = $('.minimumorder').val();
        // alert(minimum_order);
        if(parseFloat(total) >= parseFloat(minimum_order))
        {
            $('.continue_order').addClass('d-none');
            $('.continue_error').addClass('d-none');
            $('.addresspage').removeClass('d-none');
            $.ajax({
                type        : 'POST',
                url         : baseurl+'/order/placeOrder',
                data        : new FormData(this),
                contentType : false,
                cache       : false,
                processData : false,
                dataType    : 'json',
            }).done(function (response)
            {
                if(response.status == 1)
                {
                  var url =baseurl+'/order/pdfReport/'+response.data;
                  var payurl =baseurl+'/checkout/paydetails/'+response.data;
                  $('.update_url').attr('href',url);
                  $('.pay_update_url').attr('href',payurl);
                  $('#testing').trigger('click');
                  loadOff();
                //   alert('dfdfdfdf');
                }
                else
                {
                    eloadOff();
                    var errors = response.errors;
                    if(errors.length != 0)
                    {
                        $.each(response.errors, function(key,val) {
                                $('.'+key+'_error').removeClass('d-none').addClass('d-block');
                                $('.'+key+'_error').empty('').html(val);
                        });
                    }
                    $('.common_error').removeClass('d-none').addClass('d-block');
                    $('.common_error').empty('').html(response.message);
                    
                }
            });
        }
        else
        {
            eloadOff();
            $('.continue_error').removeClass('d-none');
            $('.continue_error').html('Minimum Order value greater then '+minimum_order+' rupees!');
        }
        
    });
    $(document).on('click','.quickview',function(){
        var id =$(this).attr('data-id');
        $.ajax({
            method: 'POST',
            data: {id:id},
            url  : baseurl+'/order/getItemDetails',
            dataType: 'json',
        }).done(function (response) {
            if(response.status == 1)
            {
                var data = response.data;
                $('.itemDetails').html(data);
               
            }
            else
            {
                $('.itemDetails').html('');
            }
        });
    });
    $('.pay-form').on('submit', function(e) {
        e.preventDefault();
        loadOn();
        $.ajax({
            type        : 'POST',
            url         : baseurl+'/checkout/uploadPayDetails',
            data        : new FormData(this),
            contentType : false,
            cache       : false,
            processData : false,
            dataType    : 'json',
        }).done(function (response)
        {
            if(response.status == 1)
            {
              loadOff();
              $('.common_error').removeClass('d-none').addClass('d-block');
              $('.common_error').empty('').html(response.message);
            }
            else
            {
                eloadOff();
                var errors = response.errors;
                if(errors.length != 0)
                {
                    $.each(response.errors, function(key,val) {
                            $('.'+key+'_error').removeClass('d-none').addClass('d-block');
                            $('.'+key+'_error').empty('').html(val);
                    });
                }
                $('.common_error').removeClass('d-none').addClass('d-block');
                $('.common_error').empty('').html(response.message);
                
            }
        });
    });
});
