<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Report extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->library('encryption');
		$this->load->helper('url');
        $this->load->library('Pdf');
	}
	public function index()
	{
		if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
		
        $page['page_title']   = "Order Report";
        $page['page']         = "Order Report";
        $page['method']         = "_dataList";
        $page['pre_title']    = "Order Report";
        $page['route']        = "/order/index";
        $data['page_temp']    = $this->load->view('report/manage_report',$page,TRUE);
        $data['view_file']    = "Page_Template";
        $data['currentmenu']  = "order_report";
        $this->bassthaya->load_form_template($data);
	}
    public function getOrderReport($param1='',$param2='')
    {
        $start_date = $this->input->post('start_date');
        $end_date = $this->input->post('end_date');
    
        $required = array('start_date','end_date');
        $errjsonres =[];
        $errors ='';
        foreach ($required as $key => $value) {
           if($this->input->post($value) =='')
           {
            $errors .='"'.$value.'" :"'.$value.' field is required.",';
           }
        }
        if($errors !='')
        {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{'.$errstr.'}]';
            $errjsonres = json_decode($errjson);
        }
        if(empty($errjsonres[0]))
        {
        
            $where = array(
                        'start_date' => $start_date,
                        'end_date' => $end_date,
                    );
            $url      = API_URL."api/report/order_report";
            $method   = 'POST';

            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
            //  print_r($data);exit;
            $html ='';
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                    if(!empty($data_list))
                    {

                        $html .='<div class="form-group">
                                    <a href="'.ADMIN_URL.'/report/excelOverallReport/'.$start_date.'/'.$end_date.'" class="btn btn-warning theme-btn me-2 m-t-30"><i class="fas fa-file-excel"></i> Export</a>
                                </div>
                                <table class="table table-bordered">
                                <tr class="text-center">
                                    <th>S.No</th>
                                    <th>Order Id</th>
                                    <th>Order Date</th>
                                    <th>Name</th>
                                    <th>Mobile</th>
                                    <th>Alter Mobile</th>
                                    <th>Email</th>
                                    <th>Adderss</th>
                                    <th>Pincode</th>
                                    <th>Amount</th>
                                    <th>Status</th>
                                </tr>';
                        $i=1;
                        $tot_amount=0;
                        foreach ($data_list as $key => $value) {
                            $order_code=$value['order_code'];
                            $created_at=$value['created_at'];
                            $name=$value['name'];
                            $mobile=$value['mobile'];
                            $alter_mobile=$value['alter_mobile'];
                            $email=$value['email'];
                            $address=$value['address'];
                            $pincode=$value['pincode'];
                            $total_amount=$value['total_amount'];
                            $status=$value['status'];
                            if($status == '1')
                            {
                                $statusval="New";
                            }
                            else if($status == '2')
                            {
                                $statusval="Confirm";
                            }
                            else
                            {
                                $statusval="Canceled";
                            }

                            $html .='
                                    <tr class="text-center">
                                        <td>'.$i.'</td>
                                        <td>'.$order_code.'</td>
                                        <td>'.$created_at.'</td>
                                        <td>'.$name.'</td>
                                        <td>'.$mobile.'</td>
                                        <td>'.$alter_mobile.'</td>
                                        <td>'.$email.'</td>
                                        <td>'.$address.'</td>
                                        <td>'.$pincode.'</td>
                                        <td>'.$total_amount.'</td>
                                        <td>'.$statusval.'</td>
                                    </tr>';
                            $i++;
                        }
                        $html .='
                                <tbody>
                                <table>';
                        $html .='';
                    }
                    
                    $res['status']=$data['body']['status'];
                    $res['message']=$data['body']['message'];
                    $res['data']=$html;
                    $res['errors']=[];
                    echo json_encode($res);
                    return;
                }   
                else
                {
                    $res['status']=$data['body']['status'];
                    $res['message']=$data['body']['message'];
                    $res['data']=[];
                    $res['errors']=$data['body']['errors'];
                    echo json_encode($res);
                    return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
                $res['message']='Internal server error';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
        }
        else
        {
            $res['status']=0;
            $res['message']='Invaild Input';
            $res['data']=[];
            $res['errors']=$errjsonres[0];
            echo json_encode($res);
            return;
        }
    }
    public function excelOverallReport($param1='',$param2='')
    {
        $start_date = $param1;
        $end_date = $param2;
        if($start_date !='' && $end_date !='')
        {
            $where = array(
                'start_date' => $start_date,
                'end_date' => $end_date,
            );
            $url      = API_URL."api/report/order_report";
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);exit;
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    // print_r($data['body']);
                    // exit;
                    $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                    if(!empty($data_list))
                    {
                        if($data_list[0] !='')
                        {
                            
                            $table ='<table class="table table-bordered" border="1">
                            <tr>
                                <th>S.No</th>
                                <th>Order Id</th>
                                <th>Order Date</th>
                                <th>Name</th>
                                <th>Mobile</th>
                                <th>Alter Mobile</th>
                                <th>Email</th>
                                <th>Adderss</th>
                                <th>Pincode</th>
                                <th>Amount</th>
                                <th>Status</th>
                            </tr>';
                            $i=1;
                            foreach ($data_list as $key => $value) {
                                $order_code=$value['order_code'];
                                $created_at=$value['created_at'];
                                $name=$value['name'];
                                $mobile=$value['mobile'];
                                $alter_mobile=$value['alter_mobile'];
                                $email=$value['email'];
                                $address=$value['address'];
                                $pincode=$value['pincode'];
                                $total_amount=$value['total_amount'];
                                $status=$value['status'];
                                if($status == '1')
                                {
                                    $statusval="New";
                                }
                                else if($status == '2')
                                {
                                    $statusval="Confirm";
                                }
                                else
                                {
                                    $statusval="Canceled";
                                }
                                
                                $table .='<tr align="center">
                                    <td>'.$i.'</td>
                                    <td>'.$order_code.'</td>
                                    <td>'.$created_at.'</td>
                                    <td>'.$name.'</td>
                                    <td>'.$mobile.'</td>
                                    <td>'.$alter_mobile.'</td>
                                    <td>'.$email.'</td>
                                    <td>'.$address.'</td>
                                    <td>'.$pincode.'</td>
                                    <td>'.$total_amount.'</td>
                                    <td>'.$statusval.'</td>
                                </tr>';
                                $i++;
                            }
                            $table .="</table>";
                            $filename='Order_Report'.$start_date.' - '.$end_date;
                            header("Content-type: application/octet-stream");  
                            header('Content-Disposition: attachment; filename='.$filename.'.xls');
                            header("Pragma: no-cache");  
                            header("Expires: 0");  
                            echo $table;
                            die(); 	
                        }
                    }
                } 
            }
        }
    }
}
