<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Product extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->library('encryption');
		$this->load->helper('url');
	}
	public function index()
	{
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
		$method   = $this->input->post('method');

        if($method == '_dataList')
        {
        	$search   = $this->input->post('search');
        	$status   = $this->input->post('status');
        	$page   = $this->input->post('page');
        	$limitval   = $this->input->post('limitval');

        	$cur_status = isset($status)?$status:'1';
            $cur_page   = isset($page)?$page:'1';

            $where = array(
                'limit'  => $limitval,
                'status' => $cur_status,
                'search' => $search,
            );
            $url      = API_URL."api/products/list?page=".$cur_page;
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);exit;
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                	// print_r($data['body']['data'][0]['j_list']);
                    $data_list = !empty($data['body']['data'][0]['j_list'])?$data['body']['data'][0]['j_list']:[];
                    if($data_list)
                    {
	                    $next_page = zero_check( $data['body']['data'][0]['next_page']);
	                    $prev_page = zero_check( $data['body']['data'][0]['prev_prev']);
	                    $total     = zero_check( $data['body']['data'][0]['total']);

	                    $pageData = [];
                    
                        $table = '';
                        if($cur_page == '1')
                        {
                        	$i=1;
                        }
                        else
                        {
                        	$i = (($cur_page -1) * $limitval) + 1;
                        }
                        
                        foreach ($data_list as $key => $val) {
                            $id         = empty_check($val['id']);
                            $category_name = empty_check($val['category_name']);
                            $name = empty_check($val['name']);
                            $packageName = empty_check($val['packageName']);
                            $unitPrice = empty_check($val['unitPrice']);
                            $discountPrice = empty_check($val['discountPrice']);
                            $sellingPrice = empty_check($val['sellingPrice']);
                            $availableStock = empty_check($val['availableStock']);
                            $created_at = date_check($val['created_at']);
                            $edit_btn   = '';
                            $status_btn = status_check($val['status']);
                            $edit_btn   = '<div class="overlay-edit">
                                            <a href="'.ADMIN_URL.'/product/manage_edit_form/'.$id.'" class="btn btn-icon btn-primary waves-effect waves-light" style="padding: 8px;"><i class="fas fa-edit"></i></a>
                                         </div>';
			                 // <a href="'.SITE_URL.'state/edit/'.$id.'" class="btn btn-warning waves-effect waves-light" style="padding: 8px;"><i class="icon-pencil"></i></a>
                            $status_btn = update_status($val['status'], $val['id'], 'state', 'status');
                            $table .= '
                                <tr class="row_'.$id.'">
                                    <td>'.$i.'</td>
                                    <td>'.$category_name.'</td>
                                    <td>'.$name.'</td>
                                    <td>'.$packageName.'</td>
                                    <td>'.$unitPrice.'</td>
                                    <td>'.$availableStock.'</td>
                                    <td>'.$created_at.'</td>
                                    <td>'.$status_btn.'</td>
                                    <td>'.$edit_btn.'</td>
                                </tr>
                            ';

                            $i++;
                        }

                        $pageData = array('table' => $table);

                        if($prev_page)
                        {
                            $pageData['prev_page'] = '<div data-page="'.$prev_page.'" class="pages btn btn-warning waves-effect waves-light pagination_btn">Previous</div>';
                        }

                        if($next_page)
                        {
                            $pageData['next_page'] = '<div data-page="'.$next_page.'" class="pages btn btn-success waves-effect waves-light pagination_btn">Next</div>';
                        }
                        $res['status']=$data['body']['status'];
						$res['message']=$data['body']['message'];
						$res['data']=$pageData;
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }
                    else
                    {
                    	$res['status']=0;
						$res['message']='Data Not Found';
						$res['data']=[];
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }

                    
                } 
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
        }
        else
        {
        	$page['page_title']   = "Product list";
        	$page['page']         = "Product";
        	$page['method']         = "_dataList";
			$page['pre_title']    = "Product List";
			$page['route']        = "/product/index";
			$data['page_temp']    = $this->load->view('product/manage_list',$page,TRUE);
			$data['view_file']    = "Page_Template";
			$data['currentmenu']  = "product_list";
			$this->bassthaya->load_page_template($data);
        }
	}
	public function manage_form($param1='',$param2='')
	{
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
        $where = array(
            'search' => '',
        );
        $url      = API_URL."api/category/all";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);

        $page['category'] = [];
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                if($data_list)
                {
                    $page['category'] = $data_list;
                }
            } 
        }
		$page['page_action'] = 'Craete';
		$page['page_title']   = "Product";
		$page['pre_title']    = "Create Product";
		$page['pre_menu']    = "/product";
		$page['route']       = "/product/create";
		$data['page_temp']    = $this->load->view('product/manage_form',$page,TRUE);
		$data['view_file']    = "Page_Template";
		$data['currentmenu']  = "product_form";
		$this->bassthaya->load_form_template($data);
	}
	public function create($param1='',$param2='')
	{
        $category_id = $this->input->post('category_id');
        $name = $this->input->post('name');
        $packageName = $this->input->post('packageName');
        $unitPrice = $this->input->post('unitPrice');
        // $discountPrice = $this->input->post('discountPrice');
        // $sellingPrice = $this->input->post('sellingPrice');
        $availableStock = $this->input->post('availableStock');
        // $discountPer = $this->input->post('discountPer');
		$availableStatus = $this->input->post('availableStatus');
		$pdttype = $this->input->post('pdttype');
        $required = array('category_id','name','packageName','unitPrice','availableStock','availableStatus','pdttype');
        $errjsonres =[];
        $errors ='';
        foreach ($required as $key => $value) {
           if($this->input->post($value) =='')
           {
            $errors .='"'.$value.'" :"'.$value.' field is required.",';
           }
        }
        if($errors !='')
        {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{'.$errstr.'}]';
            $errjsonres = json_decode($errjson);
        }
        if(empty($errjsonres[0]))
        {
            $imgurl1='';$imgurl2='';
            for ($i=1; $i <=2 ; $i++) { 
                if(!empty($_FILES['image'.$i]['name']))
                {
                    $img_name  = $_FILES['image'.$i]['name'];
                    $img_val   = explode('.', $img_name);
                    $img_res   = end($img_val);
                    $file_name = generateRandomString(13).'.'.$img_res;

                    $configImg['upload_path']   ='upload/products/';
                    $configImg['max_size']      = '1024';
                    $configImg['allowed_types'] = 'jpg|jpeg|png|gif';
                    $configImg['overwrite']     = FALSE;
                    $configImg['remove_spaces'] = TRUE;
                    $configImg['max_width']     = 520;
                    $configImg['max_height']    = 520;
                    $configImg['file_name']     = $file_name;
                    $this->load->library('upload', $configImg);
                    $this->upload->initialize($configImg);

                    if(!$this->upload->do_upload('image'.$i))
                    {
                        $res['status']  = 0;
                        $res['message'] = $this->upload->display_errors();
                        $res['data']    = [];
                        $res['errors']=[];
                        echo json_encode($res);
                        return;
                    }
                    else
                    {
                        if($i == 1)
                        {
                            $imgurl1 = $file_name;
                        }
                        else if($i == 2)
                        {
                            $imgurl2 = $file_name;
                        }
                       
                    }
                }
                if($imgurl1 =='')
                {                    
                    $res['status']  = 0;
                    $res['message'] = "Image is required";
                    $res['data']    = [];
                    $res['errors']=[];
                    echo json_encode($res);
                    return; 
                }
            }
			$insdata  = array('category_id' => $category_id,'name'=>$name,'packageName'=>$packageName,'unitPrice'=>$unitPrice,'availableStock'=>$availableStock,'availableStatus'=>$availableStatus,'imageUrl'=>$imgurl1,'imageUrl2'=>$imgurl2,'pdttype'=>$pdttype);
			$url      = API_URL."api/products/create";
            $method   = 'POST';

            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$insdata,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=[];
					echo json_encode($res);
					return;
                }   
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
		}
		else
		{
			$res['status']=0;
			$res['message']='Invaild Input';
			$res['data']=[];
			$res['errors']=$errjsonres[0];
			echo json_encode($res);
			return;
		}
	}
    public function manage_edit_form($param1='',$param2='')
    {
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
        
        $where = array(
            'id' => $param1,
        );
        $url      = API_URL."api/products/get_details";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);

        $page['singleDetails'] = [];
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                if($data_list)
                {
                    $page['singleDetails'] = $data_list;
                }
            } 
        }
        $where = array(
            'search' => '',
        );
        $url      = API_URL."api/category/all";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);

        $page['category'] = [];
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                if($data_list)
                {
                    $page['category'] = $data_list;
                }
            } 
        }
        $page['page_action'] = 'Edit';
        $page['page_title']   = "Product";
        $page['pre_title']    = "Edit Product";
        $page['pre_menu']    = "/product";
        $page['route']       = "/product/edit";
        $data['page_temp']    = $this->load->view('product/manage_edit_form',$page,TRUE);
        $data['view_file']    = "Page_Template";
        $data['currentmenu']  = "product_form";
        $this->bassthaya->load_form_template($data);
    }
    public function edit($param1='',$param2='')
    {
        $id = $this->input->post('id');
        $category_id = $this->input->post('category_id');
        $name = $this->input->post('name');
        $packageName = $this->input->post('packageName');
        $unitPrice = $this->input->post('unitPrice');
        // $discountPrice = $this->input->post('discountPrice');
        // $sellingPrice = $this->input->post('sellingPrice');
        $availableStock = $this->input->post('availableStock');
        // $discountPer = $this->input->post('discountPer');
        $availableStatus = $this->input->post('availableStatus');
        $pdttype = $this->input->post('pdttype');
        $imgurl1 = $this->input->post('imgurl1');
        $imgurl2 = $this->input->post('imgurl2');
        $required = array('id','category_id','name','packageName','unitPrice','availableStock','availableStatus','pdttype','imgurl1');
        $errjsonres =[];
        $errors ='';
        foreach ($required as $key => $value) {
           if($this->input->post($value) =='')
           {
            $errors .='"'.$value.'" :"'.$value.' field is required.",';
           }
        }
        if($errors !='')
        {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{'.$errstr.'}]';
            $errjsonres = json_decode($errjson);
        }
        if(empty($errjsonres[0]))
        {
            for ($i=1; $i <=2 ; $i++) { 
                if(!empty($_FILES['image'.$i]['name']))
                {
                    $img_name  = $_FILES['image'.$i]['name'];
                    $img_val   = explode('.', $img_name);
                    $img_res   = end($img_val);
                    $file_name = generateRandomString(13).'.'.$img_res;

                    $configImg['upload_path']   ='upload/products/';
                    $configImg['max_size']      = '1024';
                    $configImg['allowed_types'] = 'jpg|jpeg|png|gif';
                    $configImg['overwrite']     = FALSE;
                    $configImg['remove_spaces'] = TRUE;
                    $configImg['max_width']     = 520;
                    $configImg['max_height']    = 520;
                    $configImg['file_name']     = $file_name;
                    $this->load->library('upload', $configImg);
                    $this->upload->initialize($configImg);

                    if(!$this->upload->do_upload('image'.$i))
                    {
                        $res['status']  = 0;
                        $res['message'] = $this->upload->display_errors();
                        $res['data']    = [];
                        $res['errors']=[];
                        echo json_encode($res);
                        return;
                    }
                    else
                    {
                        if($i == 1)
                        {
                            $imgurl1 = $file_name;
                        }
                        else if($i == 2)
                        {
                            $imgurl2 = $file_name;
                        }
                    }
                }
            }
            $insdata  = array('id' => $id,'category_id' => $category_id,'name'=>$name,'packageName'=>$packageName,'unitPrice'=>$unitPrice,'availableStock'=>$availableStock,'availableStatus'=>$availableStatus,'imageUrl'=>$imgurl1,'imageUrl2'=>$imgurl2,'status' => 1,'pdttype' => $pdttype);
            // print_r($insdata);exit;
            $url      = API_URL."api/products/edit";
            $method   = 'POST';

            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$insdata,$tokenkey, $stoken, $atoken, $mkey);
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $res['status']=$data['body']['status'];
                    $res['message']=$data['body']['message'];
                    $res['data']=[];
                    $res['errors']=[];
                    echo json_encode($res);
                    return;
                }   
                else
                {
                    $res['status']=$data['body']['status'];
                    $res['message']=$data['body']['message'];
                    $res['data']=[];
                    $res['errors']=$data['body']['errors'];
                    echo json_encode($res);
                    return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
                $res['message']='Internal server error';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
        }
        else
        {
            $res['status']=0;
            $res['message']='Invaild Input';
            $res['data']=[];
            $res['errors']=$errjsonres[0];
            echo json_encode($res);
            return;
        }
    }
}
