<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->library('encryption');
		$this->load->helper('url');
        $this->load->library('Pdf');
		// $this->load->model('login_model');
	}
	public function new()
	{
		if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
		$method   = $this->input->post('method');

        if($method == '_dataList')
        {
        	$search   = $this->input->post('search');
        	$status   = $this->input->post('status');
        	$page   = $this->input->post('page');
        	$limitval   = $this->input->post('limitval');

        	$cur_status = isset($status)?$status:'1';
            $cur_page   = isset($page)?$page:'1';

            $where = array(
                'limit'  => $limitval,
                'status' => $cur_status,
                'search' => $search,
            );
            $url      = API_URL."api/order/list?page=".$cur_page;
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);exit;
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                	// print_r($data['body']['data'][0]['j_list']);
                    $data_list = !empty($data['body']['data'][0]['j_list'])?$data['body']['data'][0]['j_list']:[];
                    if($data_list)
                    {
	                    $next_page = zero_check( $data['body']['data'][0]['next_page']);
	                    $prev_page = zero_check( $data['body']['data'][0]['prev_prev']);
	                    $total     = zero_check( $data['body']['data'][0]['total']);

	                    $pageData = [];
                    
                        $table = '';
                        if($cur_page == '1')
                        {
                        	$i=1;
                        }
                        else
                        {
                        	$i = (($cur_page -1) * $limitval) + 1;
                        }
                        
                        foreach ($data_list as $key => $val) {
                            $id         = empty_check($val['id']);
                            $order_code = empty_check($val['order_code']);
                            $name = empty_check($val['name']);
                            $mobile = empty_check($val['mobile']);
                            $email = empty_check($val['email']);
                            $address = empty_check($val['address']);
                            $total_unitprice = empty_check($val['total_unitprice']);
                            $total_dis = empty_check($val['total_dis']);
                            $total_amount = empty_check($val['total_amount']);
                            // $created_at = date_check($val['created_at']);
                            $created_at = date("d-m-Y", strtotime($val['created_at']));
                            $edit_btn   = '';
                            $status_btn = status_check($val['status']);
                            $edit_btn   = '<div class="overlay-edit">
                                            <a href="'.ADMIN_URL.'/order/pdfReport/'.$id.'" class="btn btn-icon btn-primary theme-btn waves-effect waves-light" target="_blank" style="margin:3px;"><i class="fas fa-print"></i></a>
                                            <a data-id="'.$id.'" class="btn btn-icon btn-primary waves-effect waves-light order_details" style="margin:3px;"><i class="fas fa-eye"></i></a>';
                            if($val['paymentimage'] != '')
                            {
                                $edit_btn   .= ' <a data-id="'.$id.'" class="btn btn-icon btn-info waves-effect waves-light paydetails" style="margin:3px;"><i class="fas fa-check-square"></i></a>';
                            }
                            
                            $edit_btn   .= '</div>';

                            $status_btn = order_status($val['status'], $val['id'], 'state', 'status');
                            if($val['verify_status'] == '1')
                            {
                                $verify='<lable class="badge bg-warning">Not Verify</lable>';
                            }
                            else if($val['verify_status'] == '3')
                            {
                                $verify='<lable class="badge bg-danger">Rejected</lable>';
                            }
                            else
                            {
                                $verify='<lable class="badge bg-success">Verified</lable>';
                            }
                            $table .= '
                                <tr class="row_'.$id.'">
                                    <td>'.$i.'</td>
                                    <td>'.$order_code.'</td>
                                    <td>'.$created_at.'</td>
                                    <td>'.$name.'</td>
                                    <td>'.$mobile.'</td>
                                    <td>'.$email.'</td>
                                    <td>'.$address.'</td>
                                    <td>'.$total_amount.'</td>
                                    <td>'.$verify.'</td>
                                    <td>'.$edit_btn.'</td>
                                </tr>
                            ';

                            $i++;
                        }

                        $pageData = array('table' => $table);

                        if($prev_page)
                        {
                            $pageData['prev_page'] = '<div data-page="'.$prev_page.'" class="pages btn btn-warning waves-effect waves-light pagination_btn">Previous</div>';
                        }

                        if($next_page)
                        {
                            $pageData['next_page'] = '<div data-page="'.$next_page.'" class="pages btn btn-success waves-effect waves-light pagination_btn">Next</div>';
                        }
                        $res['status']=$data['body']['status'];
						$res['message']=$data['body']['message'];
						$res['data']=$pageData;
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }
                    else
                    {
                    	$res['status']=0;
						$res['message']='Data Not Found';
						$res['data']=[];
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }

                    
                } 
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
            	$this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
        }
        else
        {
        	$page['page_title']   = "New Order List";
        	$page['page']         = "New Order";
        	$page['method']         = "_dataList";
			$page['pre_title']    = "New Order List";
			$page['route']        = "/order/new";
			$data['page_temp']    = $this->load->view('order/manage_new_list',$page,TRUE);
			$data['view_file']    = "Page_Template";
			$data['currentmenu']  = "new_order_list";
			$this->bassthaya->load_page_template($data);
        }
	}
	public function cancel()
	{
		if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
		$method   = $this->input->post('method');

        if($method == '_dataList')
        {
        	$search   = $this->input->post('search');
        	$status   = $this->input->post('status');
        	$page   = $this->input->post('page');
        	$limitval   = $this->input->post('limitval');

        	$cur_status = isset($status)?$status:'3';
            $cur_page   = isset($page)?$page:'1';

            $where = array(
                'limit'  => $limitval,
                'status' => $cur_status,
                'search' => $search,
            );
            $url      = API_URL."api/order/list?page=".$cur_page;
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);exit;
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                	// print_r($data['body']['data'][0]['j_list']);
                    $data_list = !empty($data['body']['data'][0]['j_list'])?$data['body']['data'][0]['j_list']:[];
                    if($data_list)
                    {
	                    $next_page = zero_check( $data['body']['data'][0]['next_page']);
	                    $prev_page = zero_check( $data['body']['data'][0]['prev_prev']);
	                    $total     = zero_check( $data['body']['data'][0]['total']);

	                    $pageData = [];
                    
                        $table = '';
                        if($cur_page == '1')
                        {
                        	$i=1;
                        }
                        else
                        {
                        	$i = (($cur_page -1) * $limitval) + 1;
                        }
                        
                        foreach ($data_list as $key => $val) {
                            $id         = empty_check($val['id']);
                            $name = empty_check($val['name']);
                            $order_code = empty_check($val['order_code']);
                            $mobile = empty_check($val['mobile']);
                            $email = empty_check($val['email']);
                            $address = empty_check($val['address']);
                            $total_unitprice = empty_check($val['total_unitprice']);
                            $total_dis = empty_check($val['total_dis']);
                            $total_amount = empty_check($val['total_amount']);
                            // $created_at = date_check($val['created_at']);
                            $created_at = date("d-m-Y", strtotime($val['created_at']));
                            $edit_btn   = '';
                            $status_btn = status_check($val['status']);
                            $edit_btn   = '<div class="overlay-edit">
                                            <a href="'.ADMIN_URL.'/order/pdfReport/'.$id.'" class="btn btn-icon btn-primary theme-btn waves-effect waves-light" target="_blank"><i class="fas fa-print"></i></a>
                                            <a data-id="'.$id.'" class="btn btn-icon btn-primary waves-effect waves-light order_details"><i class="fas fa-eye"></i></a>
                                         </div>';

                            $status_btn = order_status($val['status'], $val['id'], 'state', 'status');
                            $table .= '
                                <tr class="row_'.$id.'">
                                    <td>'.$i.'</td>
                                    <td>'.$order_code.'</td>
                                    <td>'.$created_at.'</td>
                                    <td>'.$name.'</td>
                                    <td>'.$mobile.'</td>
                                    <td>'.$email.'</td>
                                    <td>'.$address.'</td>
                                    <td>'.$total_amount.'</td>
                                    <td>'.$status_btn.'</td>
                                    <td>'.$edit_btn.'</td>
                                </tr>
                            ';

                            $i++;
                        }

                        $pageData = array('table' => $table);

                        if($prev_page)
                        {
                            $pageData['prev_page'] = '<div data-page="'.$prev_page.'" class="pages btn btn-warning waves-effect waves-light pagination_btn">Previous</div>';
                        }

                        if($next_page)
                        {
                            $pageData['next_page'] = '<div data-page="'.$next_page.'" class="pages btn btn-success waves-effect waves-light pagination_btn">Next</div>';
                        }
                        $res['status']=$data['body']['status'];
						$res['message']=$data['body']['message'];
						$res['data']=$pageData;
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }
                    else
                    {
                    	$res['status']=0;
						$res['message']='Data Not Found';
						$res['data']=[];
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }

                    
                } 
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
            	$this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
        }
        else
        {
        	$page['page_title']   = "Canceled Order List";
        	$page['page']         = "Canceled Order";
        	$page['method']         = "_dataList";
			$page['pre_title']    = "Canceled Order List";
			$page['route']        = "/order/cancel";
			$data['page_temp']    = $this->load->view('order/manage_cancel_list',$page,TRUE);
			$data['view_file']    = "Page_Template";
			$data['currentmenu']  = "cancel_order_list";
			$this->bassthaya->load_page_template($data);
        }
	}
	public function complete()
	{
		if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
		$method   = $this->input->post('method');

        if($method == '_dataList')
        {
        	$search   = $this->input->post('search');
        	$status   = $this->input->post('status');
        	$page   = $this->input->post('page');
        	$limitval   = $this->input->post('limitval');

        	$cur_status = isset($status)?$status:'2';
            $cur_page   = isset($page)?$page:'1';

            $where = array(
                'limit'  => $limitval,
                'status' => $cur_status,
                'search' => $search,
            );
            $url      = API_URL."api/order/list?page=".$cur_page;
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);exit;
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                	// print_r($data['body']['data'][0]['j_list']);
                    $data_list = !empty($data['body']['data'][0]['j_list'])?$data['body']['data'][0]['j_list']:[];
                    if($data_list)
                    {
	                    $next_page = zero_check( $data['body']['data'][0]['next_page']);
	                    $prev_page = zero_check( $data['body']['data'][0]['prev_prev']);
	                    $total     = zero_check( $data['body']['data'][0]['total']);

	                    $pageData = [];
                    
                        $table = '';
                        if($cur_page == '1')
                        {
                        	$i=1;
                        }
                        else
                        {
                        	$i = (($cur_page -1) * $limitval) + 1;
                        }
                        
                        foreach ($data_list as $key => $val) {
                            $id         = empty_check($val['id']);
                            $order_code = empty_check($val['order_code']);
                            $name = empty_check($val['name']);
                            $mobile = empty_check($val['mobile']);
                            $email = empty_check($val['email']);
                            $address = empty_check($val['address']);
                            $total_unitprice = empty_check($val['total_unitprice']);
                            $total_dis = empty_check($val['total_dis']);
                            $total_amount = empty_check($val['total_amount']);
                            // $created_at = date_check($val['created_at']);
                            $created_at = date("d-m-Y", strtotime($val['created_at']));
                            $edit_btn   = '';
                            $status_btn = status_check($val['status']);
                            $edit_btn   = '<div class="overlay-edit">
                                            <a href="'.ADMIN_URL.'/order/pdfReport/'.$id.'" class="btn btn-icon btn-primary theme-btn waves-effect waves-light" target="_blank"><i class="fas fa-print"></i></a>
                                            <a data-id="'.$id.'" class="btn btn-icon btn-primary waves-effect waves-light order_details"><i class="fas fa-eye"></i></a>
                                         </div>';

                            $status_btn = order_status($val['status'], $val['id'], 'state', 'status');
                            $table .= '
                                <tr class="row_'.$id.'">
                                    <td>'.$i.'</td>
                                    <td>'.$order_code.'</td>
                                    <td>'.$created_at.'</td>
                                    <td>'.$name.'</td>
                                    <td>'.$mobile.'</td>
                                    <td>'.$email.'</td>
                                    <td>'.$address.'</td>
                                    <td>'.$total_amount.'</td>
                                    <td>'.$status_btn.'</td>
                                    <td>'.$edit_btn.'</td>
                                </tr>
                            ';

                            $i++;
                        }

                        $pageData = array('table' => $table);

                        if($prev_page)
                        {
                            $pageData['prev_page'] = '<div data-page="'.$prev_page.'" class="pages btn btn-warning waves-effect waves-light pagination_btn">Previous</div>';
                        }

                        if($next_page)
                        {
                            $pageData['next_page'] = '<div data-page="'.$next_page.'" class="pages btn btn-success waves-effect waves-light pagination_btn">Next</div>';
                        }
                        $res['status']=$data['body']['status'];
						$res['message']=$data['body']['message'];
						$res['data']=$pageData;
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }
                    else
                    {
                    	$res['status']=0;
						$res['message']='Data Not Found';
						$res['data']=[];
						$res['errors']=[];
						echo json_encode($res);
						return;
                    }

                    
                } 
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
            	$this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
        }
        else
        {
        	$page['page_title']   = "Confirm Order List";
        	$page['page']         = "Confirm Order";
        	$page['method']         = "_dataList";
			$page['pre_title']    = "Confirm Order List";
			$page['route']        = "/order/complete";
			$data['page_temp']    = $this->load->view('order/manage_complete_list',$page,TRUE);
			$data['view_file']    = "Page_Template";
			$data['currentmenu']  = "confirm_order_list";
			$this->bassthaya->load_page_template($data);
        }
	}
    public function getOrderdetails($param1='',$param2='')
    {
        $orderid = $this->input->post('orderid');
        $where  = array('orderid' => $orderid);
        $url      = API_URL."api/order/get_order";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
        // print_r($data);exit;
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                $html ='<div class="col-md-12"><h4>ORDER DETAILS</h4></div>
                <div class="col-md-12 d-flex padd-lr-25">
                    <div class="col-md-6" style="text-align:left;">
                        <h6>Billing Address: </h6>
                        <h6>'.$data_list[0]['name'].'</h6>
                        <p style="margin-bottom:4px;">'.$data_list[0]['address'].'</p>
                        <p style="margin-bottom:4px;">'.$data_list[0]['mobile'].'</p>
                        <p style="margin-bottom:4px;">'.$data_list[0]['email'].'</p>
                    </div>
                    <div class="col-md-6" style="text-align:right;">
                        <h5>Order Id : '.$data_list[0]['order_code'].'</h5>
                        <h6>Order Date : '.$data_list[0]['created_at'].'</h6>
                    </div>
                </div>
                <div class="dt-responsive table-responsive">
                    <h6 style="text-align:left;">Product Details: </h6>
                    <table class="table table-bordered" style="font-size:13px;">
                        <tr>
                            <th>S.No</th>
                            <th>Image</th>
                            <th>Name</th>
                            <th>Qty</th>
                            <th>Unit Price</th>
                            <th>Discount</th>
                            <th>Selling Price</th>
                            <th>Total</th>
                        </tr>';
                        $i=1;
                        foreach($data_list[0]['items'] as $key =>$value)
                        {
                            $image='<img src='.IMG_URL.'upload/products/'.$value['imageUrl'].' style="height:80px;max-width:100px;">';
                            $html .='<tr>
                                    <td>'.$i.'</td>
                                    <td>'.$image.'</td>
                                    <td>'.$value['name'].'</td>
                                    <td>'.$value['qty'].'</td>
                                    <td>'.$value['unitPrice'].'</td>
                                    <td>'.$value['discountPrice'].'</td>
                                    <td>'.$value['sellingPrice'].'</td>
                                    <td>'.$value['total'].'</td>
                                </tr>';
                            $i++;
                        }
                $html .=' <tr>
                            <th colspan="6"></th>
                            <th style="text-align:right;">Net Amount</th>
                            <th>'.$data_list[0]['total_unitprice'].'</th>
                        </tr>
                        <tr>
                            <th colspan="6"></th>
                            <th style="text-align:right;">Discount Amount</th>
                            <th>'.$data_list[0]['total_dis'].'</th>
                        </tr>
                        <tr>
                            <th colspan="6"></th>
                            <th style="text-align:right;">Total Amount</th>
                            <th>'.$data_list[0]['total_amount'].'</th>
                        </tr>
                    </table>';
                    if($data_list[0]['status'] == 1)
                    {
                        $html .='<div class="form-group">
                            <button class="btn btn-warning cancel_order" type="button" data-id="'.$orderid.'">Cancel Order</button>
                            <button class="btn btn-success confirm_order" type="button" data-id="'.$orderid.'">Confirm Order</button>
                        </div>';
                    }
                $html .='</div>';
                $res['status']=$data['body']['status'];
                $res['message']=$data['body']['message'];
                $res['data']=$html;
                $res['errors']=[];
                echo json_encode($res);
                return;
            }   
            else
            {
                $res['status']=$data['body']['status'];
                $res['message']=$data['body']['message'];
                $res['data']=[];
                $res['errors']=$data['body']['errors'];
                echo json_encode($res);
                return;
            }
        }
        else if($data['code'] == 401)
        {
            $this->session->sess_destroy();
            $res['status']=$data['code'];
            $res['message']='';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
        else if($data['code'] == 404)
        {
            $this->session->sess_destroy();
            $res['status']=$data['code'];
            $res['message']='';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
        else
        {
            $res['status']=0;
            $res['message']='Internal server error';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
    }
    public function updateOrder($param1='',$param2='')
    {
        $id = $this->input->post('id');
        $reason = $this->input->post('reason');
        $status = $this->input->post('status');
        $where  = array('id' => $id,'reason' => $reason,'status' => $status);
        $url      = API_URL."api/order/status_update";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
        // print_r($data);exit;
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $res['status']=$data['body']['status'];
                $res['message']=$data['body']['message'];
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }   
            else
            {
                $res['status']=$data['body']['status'];
                $res['message']=$data['body']['message'];
                $res['data']=[];
                $res['errors']=$data['body']['errors'];
                echo json_encode($res);
                return;
            }
        }
        else if($data['code'] == 401)
        {
            $this->session->sess_destroy();
            $res['status']=$data['code'];
            $res['message']='';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
        else if($data['code'] == 404)
        {
            $this->session->sess_destroy();
            $res['status']=$data['code'];
            $res['message']='';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
        else
        {
            $res['status']=0;
            $res['message']='Internal server error';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
    }
    public function pdfReport($param1='',$param2='')
    {
        $id = $param1;
        if($id !='')
        {
            $where = array(
                'orderid' => $id,
            );
            $url      = API_URL."api/order/get_order_pdf";
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call($url,$where);
            // print_r($data);exit;
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    // print_r($data['body']);
                    // exit;
                    $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                    if(!empty($data_list))
                    {
                        if($data_list[0] !='')
                        {
                            $created_at = date("d-m-Y", strtotime($data_list[0]['created_at']));
                            $html ='<style>
                                    td,th
                                    {
                                        font-family:"Poppins", sans-serif!important;
                                    }
                                    .invoice-logo
                                    {
                                        width:250px;
                                    }
                                    .inv_table
                                    {
                                        width:520px;
                                    }
                                    .inv_table_details
                                    {
                                        width:280px;
                                    }
                                    .font25
                                    {
                                        font-size:25px;
                                        font-weight:bold;
                                        line-height: 1.5
                                    }
                                    .font12
                                    {
                                        font-size:12px;
                                        font-weight:bold; 
                                        line-height: 1.5 
                                    }
                                    .marb-20
                                    {
                                        line-height: 1.7;
                                        font-size:10px;
                                    }
                                    .font10
                                    {
                                        font-size:10px;
                                    }
                                    .inr-dg
                                    {
                                        font-family: initial;
                                    }
                                    .outset {
                                        border-style: solid;
                                        border-width: 1px;
                                        border-color: lightgray;
                                    }
                                    .font11
                                    {
                                        font-size:11px;
                                        font-weight:bold; 
                                        line-height: 1.5 
                                    }
                                     .font13
                                    {
                                        font-size:13px;
                                        line-height: 1.5
                                    }
                                   .inv td{
                                        height:25px;
                                        border-bottom-color:#FE7601;
                                    }
                                    .part_bottom{
                                        height:25px;
                                        border-bottom-color:#FE7601;
                                    }
                                    .particular_color
                                    {
                                        height:25px;
                                        background-color:#FE7601;
                                        color:#fff;
                                    }
                                   .grand_total
                                   {
                                    color:#FE7601;
                                    font-size:12px;
                                   }
                                    </style>
                                    <table class="inv_table">
                                        <tr>
                                        <td align="left">
                                            <span class="font25">INVOICE</span><br>
                                            <span ><strong>Invoice No : '.$data_list[0]['order_code'].'</strong></span><br>
                                            <span ><strong>Date : '.$created_at.'</strong></span>
                                        </td>
                                        <td width="270" align="right">
                                            <img src="'.IMG_URL.'site-assets/logo/logo.png" style="width:150px;"><br>
                                            <span class="marb-20">4/295-I, Chima Fireworks Road,
                                            </span><br>
                                            <span class="marb-20">Kongalapuram, Sivakasi - 626189.</span><br>
                                            <span class="marb-20"> Tamil Nadu, India.</span><br>
                                            <span class="marb-20"><strong>Ph.No :</strong>+91 7010434985</span><br>
                                            <span class="marb-20"><strong>Email :</strong>sowjicrackers@gmail.com</span>';
                                            
                                        $html .='</td>
                                        </tr>
                                    </table>
                                    <table class="inv_table">
                                        <tr>
                                        <td align="left">
                                            <span class="font12">Invoice To :</span><br>
                                            <span class="font12"><strong>'.$data_list[0]['name'].'</strong></span><br>
                                            <span class="marb-20">'.$data_list[0]['address'].',</span><br>
                                            <span class="marb-20"><strong>Ph.No :</strong> '.$data_list[0]['mobile'].'</span><br>
                                            <span class="marb-20"><strong>Email Id :</strong> '.$data_list[0]['email'].'</span>
                                        </td>
                                        </tr>
                                    </table><br><br>
                                    <table class="inv">
                                    <tr>
                                        <th width ="30"align="left" class="marb-20 particular_color"><strong>&nbsp;S.no</strong></th>
                                        <th width ="200" align="left" class="marb-20 particular_color"><strong>Product</strong></th>
                                        <th width ="50" align="center" class="marb-20 particular_color"><strong>Quantity</strong></th>
                                        <th width ="60" align="center" class="marb-20 particular_color"><strong>Package</strong></th>
                                        <th width ="60" align="center" class="marb-20 particular_color"><strong>Rate</strong></th>
                                        <th width ="60" align="center" class="marb-20 particular_color"><strong>Discount</strong></th>
                                        <th width ="70" align="right" class="marb-20 particular_color"><strong>Total&nbsp;&nbsp;</strong></th>
                                    </tr>
                                   ';
                            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                            $pdf->SetTitle('Invoice Report');
                            $pdf->SetAutoPageBreak(true);
                            $pdf->SetAuthor('Author');
                            $pdf->setPrintHeader(false);
                            $pdf->setPrintFooter(false);
                            $pdf->SetDisplayMode('real', 'default');
                            $pdf->setCellHeightRatio(1.9);
                            $pdf->SetFont('freeserif', '', 10);
                            $pdf->AddPage();
                                $i=1;
                                if(!empty($data_list[0]['items']))
                                {
                                    foreach ($data_list[0]['items'] as $key => $value) {
                                        $html .='<tr>
                                                <td align="left" class="marb-20">&nbsp;'.$i.'</td>
                                                <td class="marb-20">'.$value['name'].'</td>
                                                <td align="center" class="marb-20">'.$value['qty'].'</td>
                                                <td align="center" class="marb-20">'.$value['packageName'].'</td>
                                                <td align="center" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['totunitPrice'],2).'
                                                </td>
                                                <td align="center" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['totdiscountPrice'],2).'
                                                </td>
                                                <td align="right" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['total'],2).'&nbsp;&nbsp;
                                                </td>
                                            </tr>';
                                            $i++;
                                    }
                                }
                                $html .='<tr>
                                        <th colspan="5"></th>
                                        <th align="right" class="marb-20 part_bottom"><strong>Sub Total:</strong></th>
                                        <th align="right" class="marb-20 part_bottom"><strong><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($data_list[0]['total_unitprice'],2).'&nbsp;&nbsp;</strong></th>
                                        </tr>';
                                $html .='<tr>
                                        <th colspan="5"></th>
                                        <th align="right" class="marb-20 part_bottom"><strong>Discount:</strong></th>
                                        <th align="right" class="marb-20 part_bottom"><strong><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($data_list[0]['total_dis'],2).'&nbsp;&nbsp;</strong></th>
                                        </tr>';
                                $html .='<tr>
                                        <th colspan="5"></th>
                                        <th align="right" class="grand_total part_bottom"><strong>Total:</strong></th>
                                        <th align="right" class="grand_total part_bottom"><strong><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($data_list[0]['total_amount'],2).'&nbsp;&nbsp;</strong></th>
                                        </tr>';
                            $html .="</table>";
                          
                            $pdf->writeHTML($html, true, false, true, false, '');
                            $filename='Invoice'.date('d-m-y').'.pdf';
                            $pdf->Output($filename, 'I');
                            return;
                        }
                    }
                } 
            }
        }
    }
    public function getPaydetails($param1='',$param2='')
    {
        $orderid = $this->input->post('orderid');
        $where  = array('orderid' => $orderid);
        $url      = API_URL."api/order/get_order";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
        // print_r($data);exit;
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                $html ='<div class="col-md-12"><h4>Payment Screenshot</h4></div>
                <div class="col-md-12">
                   <img src="'.IMG_URL.'/upload/payments/'.$data_list[0]['paymentimage'].'" >
                </div>
                <br>
                <div class="dt-responsive table-responsive">';
                
                if($data_list[0]['verify_status'] != 2)
                {
                    $html .='<div class="form-group">
                        <button class="btn btn-danger pay_verify_btn" type="button" data-id="'.$orderid.'" data-status="3">Reject</button>
                        <button class="btn btn-success pay_verify_btn" type="button" data-id="'.$orderid.'" data-status="2">Verify</button>
                    </div>';
                }
                $html .='</div>';
                $res['status']=$data['body']['status'];
                $res['message']=$data['body']['message'];
                $res['data']=$html;
                $res['errors']=[];
                echo json_encode($res);
                return;
            }   
            else
            {
                $res['status']=$data['body']['status'];
                $res['message']=$data['body']['message'];
                $res['data']=[];
                $res['errors']=$data['body']['errors'];
                echo json_encode($res);
                return;
            }
        }
        else if($data['code'] == 401)
        {
            $this->session->sess_destroy();
            $res['status']=$data['code'];
            $res['message']='';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
        else if($data['code'] == 404)
        {
            $this->session->sess_destroy();
            $res['status']=$data['code'];
            $res['message']='';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
        else
        {
            $res['status']=0;
            $res['message']='Internal server error';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
    }
    public function updatePayStatus($param1='',$param2='')
    {
        $id = $this->input->post('id');
        $status = $this->input->post('status');
        $where  = array('id' => $id,'status' => $status);
        $url      = API_URL."api/order/pay_status_update";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_post($url,$where,$tokenkey, $stoken, $atoken, $mkey);
        // print_r($data);exit;
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $res['status']=$data['body']['status'];
                $res['message']=$data['body']['message'];
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }   
            else
            {
                $res['status']=$data['body']['status'];
                $res['message']=$data['body']['message'];
                $res['data']=[];
                $res['errors']=$data['body']['errors'];
                echo json_encode($res);
                return;
            }
        }
        else if($data['code'] == 401)
        {
            $this->session->sess_destroy();
            $res['status']=$data['code'];
            $res['message']='';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
        else if($data['code'] == 404)
        {
            $this->session->sess_destroy();
            $res['status']=$data['code'];
            $res['message']='';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
        else
        {
            $res['status']=0;
            $res['message']='Internal server error';
            $res['data']=[];
            $res['errors']=[];
            echo json_encode($res);
            return;
        }
    }
}
