<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Offer extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->library('encryption');
		$this->load->helper('url');
		// $this->load->model('login_model');
	}
	public function manage_form()
	{
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
        $url      = API_URL."api/offer/singledata";
        $method   = 'POST';
        $tokenkey = $this->session->userdata('token_key');
        $stoken   = $this->session->userdata('stoken'); 
        $atoken   = $this->session->userdata('atoken');
        $mkey     = $this->session->userdata('mkey');
        $data = avul_call_get($url,$tokenkey, $stoken, $atoken, $mkey);
        $page['singledetails'] = [];
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                if($data_list)
                {
                    $page['singledetails'] = $data_list;
                }
            } 
        }
        // print_r($data);exit;
        if(!empty($page['singledetails']))
        {
        	$page['page_action'] = 'Edit';
			$page['page_title']   = "Offer";
			$page['pre_title']    = "Update Offer";
			$page['pre_menu']    = "/offer/manage_form";
			$page['route']       = "/offer/edit";
        }
        else
        {
        	$page['page_action'] = 'Craete';
			$page['page_title']   = "Offer";
			$page['pre_title']    = "Create Offer";
			$page['pre_menu']    = "/offer/manage_form";
			$page['route']       = "/offer/create";
        }
		
		$data['page_temp']    = $this->load->view('offer',$page,TRUE);
		$data['view_file']    = "Page_Template";
		$data['currentmenu']  = "offer";
		$this->bassthaya->load_form_template($data);
	}
	public function create($param1='',$param2='')
	{
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
        $offer = $this->input->post('offer');
        $offer_per = $this->input->post('offer_per');
		$minimum_order = $this->input->post('minimum_order');
        $required = array('offer','offer_per','minimum_order');
        $errjsonres =[];
        $errors ='';
        foreach ($required as $key => $value) {
           if($this->input->post($value) =='')
           {
            $errors .='"'.$value.'" :"'.$value.' field is required.",';
           }
        }
        if($errors !='')
        {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{'.$errstr.'}]';
            $errjsonres = json_decode($errjson);
        }
        if(empty($errjsonres[0]))
        {
			$insdata  = array('offer' => $offer,'offer_per' => $offer_per,'minimum_order' => $minimum_order);
			// print_r($insdata);exit;
			$url      = API_URL."api/offer/create";
            $method   = 'POST';

            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$insdata,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=[];
					echo json_encode($res);
					return;
                }   
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
		}
		else
		{
			$res['status']=0;
			$res['message']='Invaild Input';
			$res['data']=[];
			$res['errors']=$errjsonres[0];
			echo json_encode($res);
			return;
		}
	}
	public function edit($param1='',$param2='')
    {
        if($this->session->userdata('token_key') == '' || $this->session->userdata('atoken') == '')
        {
            redirect(ADMIN_URL.'/login');
        }
        $id = $this->input->post('id');
        $offer = $this->input->post('offer');
        $offer_per = $this->input->post('offer_per');
        $minimum_order = $this->input->post('minimum_order');
        $required = array('id','offer','offer_per','minimum_order');
        $errjsonres =[];
        $errors ='';
        foreach ($required as $key => $value) {
           if($this->input->post($value) =='')
           {
            $errors .='"'.$value.'" :"'.$value.' field is required.",';
           }
        }
        if($errors !='')
        {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{'.$errstr.'}]';
            $errjsonres = json_decode($errjson);
        }
        if(empty($errjsonres[0]))
        {
		    $insdata  = array('id' => $id,'offer' => $offer,'offer_per' => $offer_per,'minimum_order' => $minimum_order,'status' => 1);
            $url      = API_URL."api/offer/edit";
            $method   = 'POST';

            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$insdata,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $res['status']=$data['body']['status'];
                    $res['message']=$data['body']['message'];
                    $res['data']=[];
                    $res['errors']=[];
                    echo json_encode($res);
                    return;
                }   
                else
                {
                    $res['status']=$data['body']['status'];
                    $res['message']=$data['body']['message'];
                    $res['data']=[];
                    $res['errors']=$data['body']['errors'];
                    echo json_encode($res);
                    return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
                $res['message']='Internal server error';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
        }
        else
        {
            $res['status']=0;
            $res['message']='Invaild Input';
            $res['data']=[];
            $res['errors']=$errjsonres[0];
            echo json_encode($res);
            return;
        }
    }
}
