<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Order extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->library('encryption');
		$this->load->helper('url');
        $this->load->library('Pdf');
	}
	public function index()
	{
        // $this->session->unset_userdata('cart_session');
        $cart_session = $this->session->userdata('cart_session');
        if($cart_session =='')
        {
            $cart_session=generateRandomString(20);
            $this->session->set_userdata('cart_session', $cart_session);
        }
        // echo $cart_session;exit;
        $url = API_URL . "api/offer/singledatanew";
        $method = 'GET';
        $data = avul_get($url);
        // print_r($data);
        // exit();
        $page['offer']='';
        if ($data['code'] == 200) {
            if ($data['body']['status'] == 1) {
                $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                $page['offer']=$data_list[0]['offer'];
            } 
        } 
        $url      = API_URL."api/category/get_singledata";
        $method   = 'GET';
        $data = avul_get($url);

        $category_id =0;
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                if($data_list)
                {
                    $category_id = $data_list[0]['id'];
                }
            } 
        }
        $where = array('cart_session'=>$cart_session,'category_id' => $category_id);
        $url = API_URL . "api/products/get_catepdts";
        $method = 'POST';
        $data = avul_call($url, $where);
        // print_r($data);
        // exit();
        
        $page['items']=[];
        $page['nextid']=0;

        if ($data['code'] == 200) {
            if ($data['body']['status'] == 1) {
                $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                // print_r($data_list);
                $page['items']=$data_list;
                $page['nextid']=$data_list['nextCateid'];
            } 
        } 
        $url = API_URL . "api/offer/singledatanew";
        $method = 'GET';
        $data = avul_get($url);
        // print_r($data);
        // exit();
        $page['offer']='';
        if ($data['code'] == 200) {
            if ($data['body']['status'] == 1) {
                $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                $page['offer']=$data_list[0]['offer'];
            } 
        } 
		$page['page_title']   = "Order";
		$page['pre_title']    = "Order";
		$data['page_temp']    = $this->load->view('/site/order',$page,TRUE);
		$data['view_file']    = "Page_Template";
		$data['currentmenu']  = "order";
		$this->bassthaya->load_order_template($data);
	}

	public function getItems()
	{
        $category_id=$this->input->post('category_id');
        $view_type=$this->input->post('view_type');
		$lastnum=$this->input->post('lastnum');
        $required = array('category_id','view_type');
        $errjsonres = [];
        $errors = '';
        foreach ($required as $key => $value) {
            if ($this->input->post($value) == '') {
                $errors .= '"' . $value . '" :"' . $value . ' field is required.",';
            }
        }
        if ($errors != '') {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{' . $errstr . '}]';
            $errjsonres = json_decode($errjson);
        }
        if (empty($errjsonres[0])) {
            $cart_session = $this->session->userdata('cart_session');
            if($cart_session =='')
            {
                $cart_session=generateRandomString(20);
                $this->session->set_userdata('cart_session', $cart_session);
            }
            $where = array('cart_session'=>$cart_session,'category_id' => $category_id);
            $url = API_URL . "api/products/get_catepdts";
            $method = 'POST';
            $data = avul_call($url, $where);
            // print_r($data);exit;
            if ($data['code'] == 200) {
                if ($data['body']['status'] == 1) {
                    $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                    $html='';
                    if($lastnum > 0)
                    {
                        $i=$lastnum;
                    }
                    else
                    {
                        $i=1;
                    }
                    
                    foreach($data_list['items'] as $key => $value)
                    {
                        if($view_type =='desktop')
                        {
                            $html .='<tr class="product_row" id="pdt_'.$value['id'].'">
                                  <td class="text-center">
                                       '.$i.'                                     
                                    </td>
                                    <td class="product_image text-center">
                                        <img src="'.IMG_URL.'upload/products/'.$value['imageUrl'].'" id="'.$value['id'].'" alt="'.strtoupper($value['name']).'" title="'.strtoupper($value['name']).'" onClick="Javascript:ShowProductImageVideo(this);">
                                    </td>
                                    <td class="product_name text-center">
                                        '.strtoupper($value['name']).'                                          
                                    </td>
                                    <td class="product_content text-center medium_visiable">
                                        <span class="txt-yellow">'.strtoupper($value['packageName']).'</span>                                        
                                    </td>
                                    <td class="text-center">
                                         <span class="txt-pink"> <i class="fa fa-inr"></i> '.$value['unitPrice'].'</span> 
                                    </td>
                                     <td class="text-center">
                                        <span class="strike actual_price txt-red"> <i class="fa fa-inr"></i> '.$value['discountPrice'].'
                                        </span>
                                    </td>
                                    <td class="price text-center ">
                                        <span class="txt-grn"><i class="fa fa-inr"></i> '.$value['sellingPrice'].'</span>                                            
                                    </td>
                                    <td class="quantity text-center">
                                        <input type="text" name="quantity" min="1" placeholder="0" value="'.$value['cart_qty'].'" class="form-control qty_box digitval" data-id="'.$value['id'].'" data-price="'.$value['sellingPrice'].'" maxlength="3">
                                    </td>
                                    <td id="0" class="amount text-center">
                                        <input type="text" name="amount" class="form-control rate_box" disabled value="'.$value['cart_total'].'">
                                    </td>
                                </tr>';
                        }
                        else
                        {
                            $html .='<div class="d-flex product_row contact-form" style="padding:10px;background: #2B0D40;">
                                    <p class="bill1 " style="background: #2B0D40;">
                                    <span class="text-white">'.$i.'</span>
                                      <span class="cardrate">
                                        <img id="" src="'.IMG_URL.'upload/products/'.$value['imageUrl'].'" class="img-fluid cardimg cursor" alt="'.strtoupper($value['name']).'" title="'.strtoupper($value['name']).'" onClick="Javascript:ShowProductImageVideo(this);">
                                      </span>
                                        <span class="txtwidth"><strong class=text-white>'.strtoupper($value['name']).'</strong><br>
                                          <span class="theme-org">'.strtoupper($value['packageName']).'</span><br>
                                          <span class="strike theme-org"> <i class="fa fa-inr"></i> '.$value['unitPrice'].'</span>
                                          <strong><span class="txt-grn"><i class="fa fa-inr"></i> '.$value['sellingPrice'].'</span> </strong>
                                        </span>
                                        <span class="form-group">
                                          <input type="text" min="1" class="form-control qty_box digitval" name="quantity" value="'.$value['cart_qty'].'" placeholder="0" data-id="'.$value['id'].'" data-price="'.$value['sellingPrice'].'" maxlength="3"><br>
                                          <strong class=text-white>Total</strong>: <span class="amount rate_box_html text-white">'.$value['cart_total'].'</span>
                                        </span>
                                      </p>
                                </div>';
                        }
                        
                        $i++;
                    }
                    $lastnum =$i;
                    if($data_list['nextCateid'] !=0)
                      {
                        if($view_type =='desktop')
                        {
                            $html .='<tr class="category_row">
                                  <td colspan="10">
                                      '.strtoupper($data_list['nextCateName']).'                   
                                  </td>
                              </tr>
                              <tr class="text-center">
                                <td>S.No</td>
                                <td>Image</td>
                                <td class="product_name">Product Name</td>
                                <td class="medium_visiable">Content</td>
                                <td>Actual Price</td>
                                <td>80% off</td>
                                <td>Amount</td>
                                <td>Quantity</td>
                                <td>Total</td>
                            </tr>
                             <tr>
                              <td colspan="10" class="text-center loading"><span class="spinner-border ownspinner"></span></td>
                            </tr>';
                        }
                        else
                        {
                            $html .='<div class="container p-2 text-white text-center theme-bg-org">
                                      <h5 style="margin: 0px;">'.strtoupper($data_list['nextCateName']).' </h5>
                                  </div>
                                  <div class="text-center loading theme-org pt-3">
                                      <span class="spinner-border ownspinner"></span>
                                  </div>';
                        }
                      }
                    $res['status'] = $data['body']['status'];
                    $res['message'] = $data['body']['message'];
                    $res['data'] = $html;
                    $res['lastnum'] = $lastnum;
                    $res['next_id'] = $data_list['nextCateid'];
                    $res['errors'] = [];
                    echo json_encode($res);
                    return;
                } 
                else {
                    $res['status'] = $data['body']['status'];
                    $res['message'] = $data['body']['message'];
                    $res['data'] = [];
                    $res['next_id'] = '';
                    $res['errors'] = $data['body']['errors'];
                    echo json_encode($res);
                    return;
                }
            } 
            else {
                $res['status'] = 0;
                $res['message'] = 'Internal server error';
                $res['data'] = [];
                $res['errors'] = [];
                $res['next_id'] = '';
                echo json_encode($res);
                return;
            }
        } 
        else {
            $res['status'] = 0;
            $res['message'] = 'Invaild Input';
            $res['data'] = [];
            $res['next_id'] = '';
            $res['errors'] = $errjsonres[0];
            echo json_encode($res);
            return;
        }

	}
    public function addCartItems()
    {
        $id=$this->input->post('id');
        $qty=$this->input->post('qty');
        $required = array('id','qty');
        $errjsonres = [];
        $errors = '';
        foreach ($required as $key => $value) {
            if ($this->input->post($value) == '') {
                $errors .= '"' . $value . '" :"' . $value . ' field is required.",';
            }
        }
        if ($errors != '') {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{' . $errstr . '}]';
            $errjsonres = json_decode($errjson);
        }
        if (empty($errjsonres[0])) {
            $cart_session = $this->session->userdata('cart_session');
            if($cart_session =='')
            {
                $cart_session=generateRandomString(20);
                $this->session->set_userdata('cart_session', $cart_session);
            }
            $where = array('id' => $id,'qty'=>$qty,'cart_session'=>$cart_session);
            $url = API_URL . "api/products/add_cart";
            $method = 'POST';
            $data = avul_call($url, $where);
            // print_r($data);exit;
            if ($data['code'] == 200) {
                if ($data['body']['status'] == 1) {
                    $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                    $res['status'] = $data['body']['status'];
                    $res['message'] = $data['body']['message'];
                    $res['data'] =$data_list;
                    $res['errors'] = [];
                    echo json_encode($res);
                    return;
                } 
                else {
                    $res['status'] = $data['body']['status'];
                    $res['message'] = $data['body']['message'];
                    $res['data'] = [];
                    $res['errors'] = $data['body']['errors'];
                    echo json_encode($res);
                    return;
                }
            } 
            else {
                $res['status'] = 0;
                $res['message'] = 'Internal server error';
                $res['data'] = [];
                $res['errors'] = [];
                echo json_encode($res);
                return;
            }
        } 
        else {
            $res['status'] = 0;
            $res['message'] = 'Invaild Input';
            $res['data'] = [];
            $res['next_id'] = '';
            $res['errors'] = $errjsonres[0];
            echo json_encode($res);
            return;
        }
    }
    public function cartTotalDetails()
    {
        $cart_session = $this->session->userdata('cart_session');
        if($cart_session =='')
        {
            $cart_session=generateRandomString(20);
            $this->session->set_userdata('cart_session', $cart_session);
        }
        $where = array('cart_session'=>$cart_session);
        $url = API_URL . "api/products/cart_total";
        $method = 'POST';
        $data = avul_call($url, $where);
        // print_r($data);exit;
        if ($data['code'] == 200) {
            if ($data['body']['status'] == 1) {
                $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                $res['status'] = $data['body']['status'];
                $res['message'] = $data['body']['message'];
                $res['data'] =$data_list;
                $res['errors'] = [];
                echo json_encode($res);
                return;
            } 
            else {
                $res['status'] = $data['body']['status'];
                $res['message'] = $data['body']['message'];
                $res['data'] = [];
                $res['errors'] = $data['body']['errors'];
                echo json_encode($res);
                return;
            }
        } 
        else {
            $res['status'] = 0;
            $res['message'] = 'Internal server error';
            $res['data'] = [];
            $res['errors'] = [];
            echo json_encode($res);
            return;
        }
    }
    public function getCartItems()
    {
        $cart_session = $this->session->userdata('cart_session');
        if($cart_session =='')
        {
            $cart_session=generateRandomString(20);
            $this->session->set_userdata('cart_session', $cart_session);
        }
        $where = array('cart_session'=>$cart_session);
        $url = API_URL . "api/products/cart_items";
        $method = 'POST';
        $data = avul_call($url, $where);
        // print_r($data);
        if ($data['code'] == 200) {
            if ($data['body']['status'] == 1) {
                $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                $minimum_order =!empty($data_list[0]['minimum_order']) ? $data_list[0]['minimum_order'] : 0;
                $html='';
                $i=1;
                foreach($data_list as $key => $value)
                {
                    $totalamt=(float)$value['qty'] * (float)$value['sellingPrice'];
                    $html .='<li class="list-group-item py-3 ps-0 border-top">
                    <div class="row align-items-center">
                       <div class="col-6 col-md-6 col-lg-7">
                          <div class="d-flex">
                             <img src="'.IMG_URL.'upload/products/'.$value['imageUrl'].'" alt="'.$value['name'].'"
                                class="icon-shape icon-xxl">
                             <div class="ms-3">
                                <a href="pages/shop-single.html" class="text-inherit">
                                   <h6 class="mb-0">'.$value['name'].'</h6>
                                </a>
                                <div class="d-flex justify-content-between mt-4">
                                    <div>
                                    <strong><span class="text-success"><i class="fa fa-rupee"></i> '.$value['sellingPrice'].'</span></strong>
                                        
                                    </div>
                                </div>
                                <div class="mt-2 small lh-1">
                                   <a class="text-decoration-none text-inherit deleteCart" data-id="'.$value['cartid'].'">
                                      <span
                                         class="me-1 align-text-bottom">
                                         <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 24 24" fill="none"
                                            stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                            class="feather feather-trash-2 text-success">
                                            <polyline points="3 6 5 6 21 6"></polyline>
                                            <path d="M19 6v14a2 2 0 0 1-2 2H7a2 2 0 0 1-2-2V6m3 0V4a2 2 0 0 1 2-2h4a2 2 0 0 1 2 2v2">
                                            </path>
                                            <line x1="10" y1="11" x2="10" y2="17"></line>
                                            <line x1="14" y1="11" x2="14" y2="17"></line>
                                         </svg>
                                      </span>
                                      <span class="text-muted">Remove</span>
                                   </a>
                                </div>
                             </div>
                          </div>
                       </div>
                       <div class="col-4 col-md-3 col-lg-3">
                          <div class="input-group input-spinner  ">
                          <select class="form-select qty-select qtychange" data-id="'.$value['id'].'" data-price="'.$value['sellingPrice'].'">';
                                for($i=1;$i<=10;$i++)
                                {
                                    $select="";
                                    if($value['qty'] == $i)
                                    {
                                        $select="selected";
                                    }
                                        $html .='<option value="'.$i.'" '.$select.'>'.$i.'</option>';
                                }
                        $html .='</select>
                          </div>
                       </div>
                       <div class="col-2 text-lg-end text-start text-md-end col-md-2">
                          <span class="fw-bold amount rate_box_html"><i class="fa fa-rupee"></i> '.$totalamt.'</span>
                       </div>
                    </div>
                 </li>';
                $i++;
                }
                $res['status'] = $data['body']['status'];
                $res['message'] = $data['body']['message'];
                $res['data'] = $html;
                $res['minimum_order'] = $minimum_order;
                $res['errors'] = [];
                echo json_encode($res);
                return;
            } 
            else {
                $res['status'] = $data['body']['status'];
                $res['message'] = $data['body']['message'];
                $res['data'] = [];
                $res['minimum_order'] = 0;
                $res['errors'] = $data['body']['errors'];
                echo json_encode($res);
                return;
            }
        } 
        else {
            $res['status'] = 0;
            $res['message'] = 'Internal server error';
            $res['data'] = [];
            $res['errors'] = [];
            echo json_encode($res);
            return;
        }

    }
    public function deleteCart()
    {
        $id=$this->input->post('id');
        $required = array('id');
        $errjsonres = [];
        $errors = '';
        foreach ($required as $key => $value) {
            if ($this->input->post($value) == '') {
                $errors .= '"' . $value . '" :"' . $value . ' field is required.",';
            }
        }
        if ($errors != '') {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{' . $errstr . '}]';
            $errjsonres = json_decode($errjson);
        }
        if (empty($errjsonres[0])) {
            
            $where = array('id'=>$id);
            $url = API_URL . "api/products/cart_delete";
            $method = 'POST';
            $data = avul_call($url, $where);
            if ($data['code'] == 200) {
                if ($data['body']['status'] == 1) {
                    $res['status'] = $data['body']['status'];
                    $res['message'] = $data['body']['message'];
                    $res['data'] = [];
                    $res['errors'] = [];
                    echo json_encode($res);
                    return;
                } 
                else {
                    $res['status'] = $data['body']['status'];
                    $res['message'] = $data['body']['message'];
                    $res['data'] = [];
                    $res['errors'] = $data['body']['errors'];
                    echo json_encode($res);
                    return;
                }
            } 
            else {
                $res['status'] = 0;
                $res['message'] = 'Internal server error';
                $res['data'] = [];
                $res['errors'] = [];
                echo json_encode($res);
                return;
            }
        } 
        else {
            $res['status'] = 0;
            $res['message'] = 'Invaild Input';
            $res['data'] = [];
            $res['errors'] = $errjsonres[0];
            echo json_encode($res);
            return;
        }

    }
    public function getItemDetails()
    {
        $cart_session = $this->session->userdata('cart_session');
        if($cart_session =='')
        {
            $cart_session=generateRandomString(20);
            $this->session->set_userdata('cart_session', $cart_session);
        }
        $id = $this->input->post('id');
        $where = array('id'=>$id,'cart_session'=>$cart_session);
        $url = API_URL . "api/products/getdetails";
        $method = 'POST';
        $data = avul_call($url, $where);
        // print_r($data);
        if ($data['code'] == 200) {
            if ($data['body']['status'] == 1) {
                $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                $html='
                    <div class="row">
                        <div class="col-lg-6">
                        <div class="product productModal" id="productModal">
                            <div
                                class="zoom"
                                onmousemove="zoom(event)"
                                style="
                                background-image: url('.IMG_URL.'upload/products/'.$data_list[0]['imageUrl'].');
                                "
                                >
                                <img
                                    src="'.IMG_URL.'upload/products/'.$data_list[0]['imageUrl'].'"
                                    alt=""
                                    >
                            </div>
                            <div
                                class="zoom"
                                onmousemove="zoom(event)"
                                style="
                                background-image: url('.IMG_URL.'upload/products/'.$data_list[0]['imageUrl2'].');
                                "
                                >
                                <img
                                    src="'.IMG_URL.'upload/products/'.$data_list[0]['imageUrl2'].'"
                                    alt=""
                                    >
                            </div>
                        </div>
                        <div class="product-tools">
                            <div class="thumbnails row g-3" id="productModalThumbnails">
                                <div class="col-3 tns-nav-active">
                                    <div class="thumbnails-img">
                                    <img
                                        src="'.IMG_URL.'upload/products/'.$data_list[0]['imageUrl'].'"
                                        alt=""
                                        >
                                    </div>
                                </div>
                                <div class="col-3">
                                    <div class="thumbnails-img">
                                    <img
                                        src="'.IMG_URL.'upload/products/'.$data_list[0]['imageUrl2'].'"
                                        alt=""
                                        >
                                    </div>
                                </div>
                            </div>
                        </div>
                        </div>
                        <div class="col-lg-6">
                        <div class="ps-lg-8 mt-6 mt-lg-0">
                            <a href="#!" class="mb-4 d-block">'.$data_list[0]['category_name'].'</a>
                            <h2 class="mb-1 h1">'.$data_list[0]['name'].'</h2>
                            
                            <div class="fs-4">
                                <span class="fw-bold text-success"><i class="fa fa-rupee"></i> '.$data_list[0]['sellingPrice'].'</span>
                                
                            </div>
                            <hr class="my-6">
                            <div>';
                                if($data_list[0]['cart_qty'] > 0)
                                {
                                $upqty="qtychange";
                                }
                                else
                                {
                                $upqty="";
                                }
                        $html .='<div class="col-lg-4 col-md-5 col-6 d-grid">
                        <select class="form-select qty-select '.$upqty.'" data-id="'.$data_list[0]['id'].'" data-price="'.$data_list[0]['sellingPrice'].'">';
                                    for($i=1;$i<=10;$i++)
                                    {
                                    $select="";
                                    if($data_list[0]['cart_qty'] == $i)
                                    {
                                        $select="selected";
                                    }
                                    $html .='<option value="'.$i.'"'.$select.'>'.$i.'</option>';
                                    }
                            $html .='</select>
                            </div>
                            </div>
                            <div class="col-lg-4 col-md-5 col-6 d-grid mt-3 row justify-content-start g-2 align-items-center"
                                >
                                <a class="btn btn-primary theme-btn addtocart"  data-id="'.$data_list[0]['id'].'" data-price="'.$data_list[0]['sellingPrice'].'">';
                                
                                if($data_list[0]['cart_qty'] > 0)
                                {
                                    $html .='Added';
                                }
                                else
                                {
                                    $html .='<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none"
                                      stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"
                                      class="feather feather-plus">
                                      <line x1="12" y1="5" x2="12" y2="19"></line>
                                      <line x1="5" y1="12" x2="19" y2="12"></line>
                                   </svg>
                                   Add to Cart';
                                } 
                            $html .='</a>
                            </div>
                            <hr class="my-6">
                            <div>
                                <table class="table table-borderless">
                                    <tbody>
                                    <tr>
                                        <td>Package:</td>
                                        <td>'.$data_list[0]['packageName'].'</td>
                                    </tr>
                                    <tr>
                                        <td>Availability:</td>
                                        <td>'.$data_list[0]['availableStatus'].'</td>
                                    </tr>
                                    <tr>
                                        <td>Type:</td>
                                        <td>Cracker</td>
                                    </tr>
                                    <tr>
                                        <td>Category:</td>
                                        <td>
                                        '.$data_list[0]['category_name'].'
                                        </td>
                                    </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        </div>
                    </div>
                    <script src="'.SCRIPT_URL.'site-assets/libs/tiny-slider/dist/min/tiny-slider.js"></script>
                    <script src="'.SCRIPT_URL.'site-assets/js/vendors/tns-slider.js"></script>';
                $res['status'] = $data['body']['status'];
                $res['message'] = $data['body']['message'];
                $res['data'] = $html;
                $res['errors'] = [];
                echo json_encode($res);
                return;
            } 
            else {
                $res['status'] = $data['body']['status'];
                $res['message'] = $data['body']['message'];
                $res['data'] = [];
                $res['minimum_order'] = 0;
                $res['errors'] = $data['body']['errors'];
                echo json_encode($res);
                return;
            }
        } 
        else {
            $res['status'] = 0;
            $res['message'] = 'Internal server error';
            $res['data'] = [];
            $res['errors'] = [];
            echo json_encode($res);
            return;
        }

    }
    public function placeOrder()
    {
        $name=$this->input->post('name');
        $mobile=$this->input->post('mobile');
        $alter_mobile=$this->input->post('alter_mobile');
        $email=$this->input->post('email');
        $address=$this->input->post('address');
        $pincode=$this->input->post('pincode');
        $minimum_order=$this->input->post('minimum_order');
        $required = array('name','mobile','email','address','pincode');
        $errjsonres = [];
        $errors = '';
        foreach ($required as $key => $value) {
            if ($this->input->post($value) == '') {
                $errors .= '"' . $value . '" :"' . $value . ' field is required.",';
            }
        }
        if ($errors != '') {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{' . $errstr . '}]';
            $errjsonres = json_decode($errjson);
        }
        if (empty($errjsonres[0])) {
            $cart_session = $this->session->userdata('cart_session');
            if($cart_session =='')
            {
                $cart_session=generateRandomString(20);
                $this->session->set_userdata('cart_session', $cart_session);
            }
            $where = array('cart_session'=>$cart_session,'name'=>$name,'mobile'=>$mobile,'alter_mobile'=>$alter_mobile,'email'=>$email,'address'=>$address,'pincode'=>$pincode,'minimum_order'=>$minimum_order);
            $url = API_URL . "api/products/place_order";
            $method = 'POST';
            $data = avul_call($url, $where);
            if ($data['code'] == 200) {
                if ($data['body']['status'] == 1) {
                    $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                    $this->sendMail($data_list);
                    session_destroy();
                    $res['status'] = $data['body']['status'];
                    $res['message'] = $data['body']['message'];
                    $res['data'] = $data_list;
                    $res['errors'] = [];
                    echo json_encode($res);
                    return;
                } 
                else {
                    $res['status'] = $data['body']['status'];
                    $res['message'] = $data['body']['message'];
                    $res['data'] = [];
                    $res['errors'] = $data['body']['errors'];
                    echo json_encode($res);
                    return;
                }
            } 
            else {
                $res['status'] = 0;
                $res['message'] = 'Internal server error';
                $res['data'] = [];
                $res['errors'] = [];
                echo json_encode($res);
                return;
            }
        } 
        else {
            $res['status'] = 0;
            $res['message'] = 'Invaild Input';
            $res['data'] = [];
            $res['errors'] = $errjsonres[0];
            echo json_encode($res);
            return;
        }

    }
    public function pdfReport($param1='',$param2='')
    {
        $id = $param1;
        if($id !='')
        {
            $where = array(
                'orderid' => $id,
            );
            $url      = API_URL."api/order/get_order_pdf";
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call($url,$where);
            // print_r($data);exit;
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    // print_r($data['body']);
                    // exit;
                    $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                    if(!empty($data_list))
                    {
                        if($data_list[0] !='')
                        {
                            $created_at = date("d-m-Y", strtotime($data_list[0]['created_at']));
                            $html ='<style>
                                    td,th
                                    {
                                        font-family:"Poppins", sans-serif!important;
                                    }
                                    .invoice-logo
                                    {
                                        width:250px;
                                    }
                                    .inv_table
                                    {
                                        width:520px;
                                    }
                                    .inv_table_details
                                    {
                                        width:280px;
                                    }
                                    .font25
                                    {
                                        font-size:25px;
                                        font-weight:bold;
                                        line-height: 1.5
                                    }
                                    .font12
                                    {
                                        font-size:12px;
                                        font-weight:bold; 
                                        line-height: 1.5 
                                    }
                                    .marb-20
                                    {
                                        line-height: 1.7;
                                        font-size:10px;
                                    }
                                    .font10
                                    {
                                        font-size:10px;
                                    }
                                    .inr-dg
                                    {
                                        font-family: initial;
                                    }
                                    .outset {
                                        border-style: solid;
                                        border-width: 1px;
                                        border-color: lightgray;
                                    }
                                    .font11
                                    {
                                        font-size:11px;
                                        font-weight:bold; 
                                        line-height: 1.5 
                                    }
                                     .font13
                                    {
                                        font-size:13px;
                                        line-height: 1.5
                                    }
                                   .inv td{
                                        height:25px;
                                        border-bottom-color:#FE7601;
                                    }
                                    .part_bottom{
                                        height:25px;
                                        border-bottom-color:#FE7601;
                                    }
                                    .particular_color
                                    {
                                        height:25px;
                                        background-color:#FE7601;
                                        color:#fff;
                                    }
                                   .grand_total
                                   {
                                    color:#FE7601;
                                    font-size:12px;
                                   }
                                    </style>
                                    <table class="inv_table">
                                        <tr>
                                        <td align="left">
                                            <span class="font25">INVOICE</span><br>
                                            <span ><strong>Invoice No : '.$data_list[0]['order_code'].'</strong></span><br>
                                            <span ><strong>Date : '.$created_at.'</strong></span>
                                        </td>
                                        <td width="270" align="right">
                                            <img src="'.IMG_URL.'site-assets/logo/logo.png" style="width:150px;"><br>
                                            <span class="marb-20">4/295-I, Chima Fireworks Road,
                                            </span><br>
                                            <span class="marb-20">Kongalapuram, Sivakasi - 626189.</span><br>
                                            <span class="marb-20"> Tamil Nadu, India.</span><br>
                                            <span class="marb-20"><strong>Ph.No :</strong>+91 7305885413</span><br>
                                            <span class="marb-20"><strong>Email :</strong>sales@crackersfrommakers.in</span>';
                                            
                                        $html .='</td>
                                        </tr>
                                    </table>
                                    <table class="inv_table">
                                        <tr>
                                        <td align="left">
                                            <span class="font12">Invoice To :</span><br>
                                            <span class="font12"><strong>'.$data_list[0]['name'].'</strong></span><br>
                                            <span class="marb-20">'.$data_list[0]['address'].',</span><br>
                                            <span class="marb-20"><strong>Ph.No :</strong> '.$data_list[0]['mobile'].'</span><br>
                                            <span class="marb-20"><strong>Email Id :</strong> '.$data_list[0]['email'].'</span>
                                        </td>
                                        </tr>
                                    </table><br><br>
                                    <table class="inv">
                                    <tr>
                                        <th width ="30"align="left" class="marb-20 particular_color"><strong>&nbsp;S.no</strong></th>
                                        <th width ="200" align="left" class="marb-20 particular_color"><strong>Product</strong></th>
                                        <th width ="50" align="center" class="marb-20 particular_color"><strong>Quantity</strong></th>
                                        <th width ="60" align="center" class="marb-20 particular_color"><strong>Package</strong></th>
                                        <th width ="60" align="center" class="marb-20 particular_color"><strong>Rate</strong></th>
                                        <th width ="60" align="center" class="marb-20 particular_color"><strong>Discount</strong></th>
                                        <th width ="70" align="right" class="marb-20 particular_color"><strong>Total&nbsp;&nbsp;</strong></th>
                                    </tr>
                                   ';
                            $pdf = new Pdf('P', 'mm', 'A4', true, 'UTF-8', false);
                            $pdf->SetTitle('Invoice Report');
                            $pdf->SetAutoPageBreak(true);
                            $pdf->SetAuthor('Author');
                            $pdf->setPrintHeader(false);
                            $pdf->setPrintFooter(false);
                            $pdf->SetDisplayMode('real', 'default');
                            $pdf->setCellHeightRatio(1.9);
                            $pdf->SetFont('freeserif', '', 10);
                            $pdf->AddPage();
                                $i=1;
                                if(!empty($data_list[0]['items']))
                                {
                                    foreach ($data_list[0]['items'] as $key => $value) {
                                        $html .='<tr>
                                                <td align="left" class="marb-20">&nbsp;'.$i.'</td>
                                                <td class="marb-20">'.$value['name'].'</td>
                                                <td align="center" class="marb-20">'.$value['qty'].'</td>
                                                <td align="center" class="marb-20">'.$value['packageName'].'</td>
                                                <td align="center" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['totunitPrice'],2).'
                                                </td>
                                                <td align="center" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['totdiscountPrice'],2).'
                                                </td>
                                                <td align="right" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['total'],2).'&nbsp;&nbsp;
                                                </td>
                                            </tr>';
                                            $i++;
                                    }
                                }
                                $html .='<tr>
                                        <th colspan="5"></th>
                                        <th align="right" class="grand_total part_bottom"><strong>Total:</strong></th>
                                        <th align="right" class="grand_total part_bottom"><strong><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($data_list[0]['total_amount'],2).'&nbsp;&nbsp;</strong></th>
                                        </tr>';
                            $html .="</table>";
                          
                            $pdf->writeHTML($html, true, false, true, false, '');
                            $filename='Invoice'.date('d-m-y').'.pdf';
                            $pdf->Output($filename, 'I');
                            return;
                        }
                    }
                } 
            }
        }
    }
    public function sendMail($param1='',$param2='')
    {
        $id = $param1;
        if($id !='')
        {
            $where = array(
                'orderid' => $id,
            );
            $url      = API_URL."api/order/get_order_pdf";
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call($url,$where);
            // print_r($data);exit;
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    // print_r($data['body']);
                    // exit;
                    $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                    if(!empty($data_list))
                    {
                        if($data_list[0] !='')
                        {
                            $created_at = date("d-m-Y", strtotime($data_list[0]['created_at']));
        
                            $subject = 'Order successful for '.SITE_NAME;
                            $buffer  = '
                                <!DOCTYPE html>
                                <html>
                                <head>
                                    <title>Payment View</title>
                                    <style type="text/css">
                                            #header
                                            {
                                                background-color: #FE7601;
                                                padding: 10px 0px 20px 0px;
                                                margin: 0;
                                                text-align: center;
                                                color: #fff;
                                                font-size: 20px;
                                            }
                                            #headertop
                                            {
                                                margin: 0;
                                                text-align: center;
                                                color: #000;
                                                font-size: 20px;
                                            }
                                            #card_page
                                            {
                                                width: 100%;
                                            }
                                            td,th
                                            {
                                                font-family:"Poppins", sans-serif!important;
                                            }
                                            .invoice-logo
                                            {
                                                width:250px;
                                            }
                                            .inv_table
                                            {
                                                width:100%;
                                                border-spacing: 0px;
                                            }
                                            .inv_table_details
                                            {
                                                width:280px;
                                            }
                                            .font25
                                            {
                                                font-size:25px;
                                                font-weight:bold;
                                                line-height: 1.5
                                            }
                                            .font12
                                            {
                                                font-size:13px;
                                                font-weight:bold; 
                                                line-height: 1.5 
                                            }
                                            .marb-20
                                            {
                                                line-height: 1.7;
                                                font-size:13px;
                                            }
                                            .font10
                                            {
                                                font-size:10px;
                                            }
                                            .inr-dg
                                            {
                                                font-family: initial;
                                            }
                                            .outset {
                                                border-style: solid;
                                                border-width: 1px;
                                                border-color: lightgray;
                                            }
                                            .font11
                                            {
                                                font-size:11px;
                                                font-weight:bold; 
                                                line-height: 1.5 
                                            }
                                            .font13
                                            {
                                                font-size:13px;
                                                line-height: 1.5
                                            }
                                        .inv td{
                                                border-style: solid;
                                                border-width: 1px;
                                                height:25px;
                                                border-bottom-color:#FE7601;
                                                border-bottom-color:#FE7601;
                                                border-top-color:#fff;
                                                border-left-color:#fff;
                                                border-right-color:#fff;
                                            }
                                            .part_bottom{
                                                border-style: solid;
                                                border-width: 1px;
                                                height:25px;
                                                border-bottom-color:#FE7601;
                                                border-top-color:#fff;
                                                border-left-color:#fff;
                                                border-right-color:#fff;
                                            }
                                            .particular_color
                                            {
                                                height:25px;
                                                background-color:#FE7601;
                                                color:#fff;
                                                border-bottom-color:#FE7601;
                                                border-top-color:#fff;
                                                border-left-color:#fff;
                                                border-right-color:#fff;
                                            }
                                        .grand_total
                                        {
                                            color:#FE7601;
                                            font-size:12px;
                                        }
                                        .btn {
                                            display: inline-block;
                                            font-weight: 400;
                                            line-height: 1.5;
                                            color: #fff;
                                            text-align: center;
                                            vertical-align: middle;
                                            cursor: pointer;
                                            -webkit-user-select: none;
                                            -moz-user-select: none;
                                            -ms-user-select: none;
                                            user-select: none;
                                            background-color: transparent;
                                            border: 1px solid transparent;
                                            padding: 0.375rem 0.95rem;
                                            font-size: .875rem;
                                            border-radius: 2px;
                                            transition: color .15s ease-in-out,background-color .15s ease-in-out,border-color .15s ease-in-out,box-shadow .15s ease-in-out;
                                        }
                                        .btn-primary {
                                            color: #fff;
                                            background-color: #FE7601;
                                            border-color: #FE7601;
                                        }
                                    </style>
                                </head>
                                <body>
                                <div id="headertop">
                                    <div class="container">
                                        <div class="row">
                                            <span class="font25">INVOICE</span>
                                        </div>
                                    </div>
                                </div>
                                <div id="header">
                                    <div class="container">
                                        <div class="row">
                                            <img src="'.IMG_URL.'site-assets/images/logo.png" style="width:150px;">
                                        </div>
                                    </div>
                                </div>
                                <div id="card_page">
                                <div class="container">
                                    <div class="row">
                                        <div class="card">
                                            <table class="inv_table">
                                                    <tr>
                                                    <td align="left">
                                                        <span ><strong>Invoice No : '.$data_list[0]['order_code'].'</strong></span><br>
                                                        <span ><strong>Date : '.$created_at.' </strong></span>
                                                    </td>
                                                    <td align="right">
                                                        <span ><strong>Sowji Crackers</strong></span><br>
                                                        <span class="marb-20">4/295-I, Chima Fireworks Road,
                                                        </span><br>
                                                        <span class="marb-20">Kongalapuram, Sivakasi - 626189.</span><br>
                                                        <span class="marb-20"> Tamil Nadu, India.</span><br>
                                                        <span class="marb-20"><strong>Ph.No :</strong>+91 7305885413</span><br>
                                                        <span class="marb-20"><strong>Email :</strong>sales@crackersfrommakers.in</span>
                                                        </td>
                                                    </tr>
                                                </table>
                                                <table class="inv_table">
                                                    <tr>
                                                    <td align="left">
                                                        <span class="font12">Invoice To :</span><br>
                                                        <span class="font12"><strong>'.$data_list[0]['name'].'</strong></span><br>
                                                        <span class="marb-20">'.$data_list[0]['address'].',</span><br>
                                                        <span class="marb-20"><strong>Ph.No :</strong> '.$data_list[0]['mobile'].'</span><br>
                                                        <span class="marb-20"><strong>Email Id :</strong>'.$data_list[0]['email'].'</span>
                                                    </td>
                                                    </tr>
                                                </table><br><br>
                                                <table class="inv_table inv">
                                                <tr>
                                                    <th align="left" class="marb-20 particular_color"><strong>&nbsp;S.no</strong></th>
                                                    <th align="left" class="marb-20 particular_color"><strong>Product</strong></th>
                                                    <th align="center" class="marb-20 particular_color"><strong>Quantity</strong></th>
                                                    <th align="center" class="marb-20 particular_color"><strong>Package</strong></th>
                                                    <th align="center" class="marb-20 particular_color"><strong>Rate</strong></th>
                                                    <th align="center" class="marb-20 particular_color"><strong>Discount</strong></th>
                                                    <th align="right" class="marb-20 particular_color"><strong>Total&nbsp;&nbsp;</strong></th>
                                                </tr>';
                                                $i=1;
                                                if(!empty($data_list[0]['items']))
                                                {
                                                    foreach ($data_list[0]['items'] as $key => $value) {
                                                        $buffer .='<tr>
                                                                <td align="left" class="marb-20">&nbsp;'.$i.'</td>
                                                                <td class="marb-20">'.$value['name'].'</td>
                                                                <td align="center" class="marb-20">'.$value['qty'].'</td>
                                                                <td align="center" class="marb-20">'.$value['packageName'].'</td>
                                                                <td align="center" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['totunitPrice'],2).'
                                                                </td>
                                                                <td align="center" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['totdiscountPrice'],2).'
                                                                </td>
                                                                <td align="right" class="marb-20"><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($value['total'],2).'&nbsp;&nbsp;
                                                                </td>
                                                            </tr>';
                                                            $i++;
                                                    }
                                                }
                                                $buffer .='
                                                <tr>
                                                    <th colspan="5"></th>
                                                    <th align="right" class="grand_total part_bottom"><strong>Total:</strong></th>
                                                    <th align="right" class="grand_total part_bottom"><strong><span style="font-family:dejavusans;font-size:10px;">&#8377;</span>'.number_format($data_list[0]['total_amount'],2).'&nbsp;&nbsp;</strong></th>
                                                    </tr>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                    <div id="headertop">
                                    <div class="container">
                                        <div class="row">
                                            <a href="'.BASE_URL.'/order/pdfReport/'.$id.'" class="btn btn-primary">Print PDF</a> 
                                        </div>
                                    </div>
                                </div>
                                </div>
                                </body>
                                </html>
                            ';

                            // Multiple recipients
                            $to = $data_list[0]['email']; // note the comma
                            $headers = "MIME-Version: 1.0" . "\r\n";
                            $headers .= "Content-type: text/html; charset=iso-8859-1" . "\r\n";
                            $headers .= "From:Sowji Crackers  support@crackersfrommakers.in" . "\r\n" .
                            "Reply-To:  support@crackersfrommakers.in" . "\r\n" .
                            "Return-Path:  support@crackersfrommakers.in" . "\r\n" .
                            "CC:  sales@crackersfrommakers.in" . "\r\n" .
                            "X-Mailer: PHP/" . phpversion();
                            mail($to, $subject, $buffer, $headers,"-fsupport@crackersfrommakers.in");
                            return;
                        }
                    }
                }
            }
        }
    }

}
