<?php
defined('BASEPATH') OR exit('No direct script access allowed');

class Checkout extends CI_Controller {

	public function __construct()
	{
		parent::__construct();
		$this->load->library('session');
		$this->load->library('encryption');
		$this->load->helper('url');
        $this->load->library('Pdf');
	}
	public function index()
	{
        // $this->session->unset_userdata('cart_session');
        $cart_session = $this->session->userdata('cart_session');
        if($cart_session =='')
        {
            $cart_session=generateRandomString(20);
            $this->session->set_userdata('cart_session', $cart_session);
        }
        $url = API_URL . "api/offer/singledatanew";
        $method = 'GET';
        $data = avul_get($url);
        // print_r($data);
        // exit();
        $page['offer']='';
        if ($data['code'] == 200) {
            if ($data['body']['status'] == 1) {
                $data_list = !empty($data['body']['data']) ? $data['body']['data'] : [];
                $page['offer']=$data_list[0]['offer'];
            } 
        } 
        // echo $cart_session;exit;

        $where = array('cart_session'=>$cart_session);
        $url = API_URL . "api/products/cart_items";
        $method = 'POST';
        $data = avul_call($url, $where);
        // print_r($data);exit;
        $cartItems =0;
        $minorder =0;
        if($data['code'] == 200)
        {
            if($data['body']['status'] == 1)
            {
                $cartItems = !empty($data['body']['data']) ? $data['body']['data'] : [];
                $minorder = !empty($data['body']['data'][0]['minimum_order'])?$data['body']['data'][0]['minimum_order']:0;
            } 
        }
        // print_r($cartItems);exit;
		$page['minimum_order']   = $minorder;
		$page['cartItems']   = $cartItems;
		$page['page_title']   = "Checkout";
		$page['pre_title']    = "Checkout";
		$data['page_temp']    = $this->load->view('/site/checkout',$page,TRUE);
		$data['view_file']    = "Page_Template";
		$data['currentmenu']  = "checkout";
		$this->bassthaya->load_site_template($data);
	}
    public function paydetails($param1="")
    {
        $id = $param1;
        if($id !='')
        {
            $where = array(
                'orderid' => $id,
            );
            $url      = API_URL."api/order/get_order_pdf";
            $method   = 'POST';
            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call($url,$where);
            // print_r($data);exit;
            $page['orderdetails']=[];
            if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $data_list = !empty($data['body']['data'])?$data['body']['data']:[];
                    if(!empty($data_list))
                    {
                        $page['orderdetails']=$data_list;
                    }
                }
            }
            $page['orderid']   = $param1;
            $page['page_title']   = "Pay Details";
            $page['pre_title']    = "Pay Details";
            $data['page_temp']    = $this->load->view('/site/paydetails',$page,TRUE);
            $data['view_file']    = "Page_Template";
            $data['currentmenu']  = "paydetails";
            $this->bassthaya->load_paysite_template($data);
        }
    }
    public function uploadPayDetails($param1='',$param2='')
	{
        $orderid = $this->input->post('orderid');
        
        $required = array('orderid');
        $errjsonres =[];
        $errors ='';
        foreach ($required as $key => $value) {
           if($this->input->post($value) =='')
           {
            $errors .='"'.$value.'" :"'.$value.' field is required.",';
           }
        }
        if($errors !='')
        {
            $errstr = substr($errors, 0, -1);
            $errjson = '[{'.$errstr.'}]';
            $errjsonres = json_decode($errjson);
        }
        if(empty($errjsonres[0]))
        {
            $imgurl ='';
            if(!empty($_FILES['image']['name']))
            {
                $img_name  = $_FILES['image']['name'];
                $img_val   = explode('.', $img_name);
                $img_res   = end($img_val);
                $file_name = generateRandomString(13).'.'.$img_res;

                $configImg['upload_path']   ='upload/payments/';
                $configImg['max_size']      = '2024';
                $configImg['allowed_types'] = 'jpg|jpeg|png|gif';
                $configImg['overwrite']     = FALSE;
                $configImg['remove_spaces'] = TRUE;
                $configImg['max_width']     = 1400;
                $configImg['max_height']    = 1000;
                $configImg['file_name']     = $file_name;
                $this->load->library('upload', $configImg);
                $this->upload->initialize($configImg);

                if(!$this->upload->do_upload('image'))
                {
                    $res['status']  = 0;
                    $res['message'] = $this->upload->display_errors();
                    $res['data']    = [];
                    $res['errors']=[];
                    echo json_encode($res);
                    return;
                }
                else
                {
                    $imgurl =$file_name;
                }
            }
            else
            {
                $res['status']=0;
				$res['message']='Payment screenshot is required';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
			$insdata  = array('id' => $orderid,'paymentimage'=>$imgurl);
			$url      = API_URL."api/order/upload_paydetail";
            $method   = 'POST';

            $tokenkey = $this->session->userdata('token_key');
            $stoken   = $this->session->userdata('stoken'); 
            $atoken   = $this->session->userdata('atoken');
            $mkey     = $this->session->userdata('mkey');
            $data = avul_call_post($url,$insdata,$tokenkey, $stoken, $atoken, $mkey);
            // print_r($data);
			if($data['code'] == 200)
            {
                if($data['body']['status'] == 1)
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=[];
					echo json_encode($res);
					return;
                }   
                else
                {
                    $res['status']=$data['body']['status'];
					$res['message']=$data['body']['message'];
					$res['data']=[];
					$res['errors']=$data['body']['errors'];
					echo json_encode($res);
					return;
                }
            }
            else if($data['code'] == 401)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else if($data['code'] == 404)
            {
                $this->session->sess_destroy();
                $res['status']=$data['code'];
                $res['message']='';
                $res['data']=[];
                $res['errors']=[];
                echo json_encode($res);
                return;
            }
            else
            {
                $res['status']=0;
				$res['message']='Internal server error';
				$res['data']=[];
				$res['errors']=[];
				echo json_encode($res);
				return;
            }
		}
		else
		{
			$res['status']=0;
			$res['message']='Invaild Input';
			$res['data']=[];
			$res['errors']=$errjsonres[0];
			echo json_encode($res);
			return;
		}
	}
}
