<?php

  

namespace App\Filters;

  

use CodeIgniter\Filters\FilterInterface;

use CodeIgniter\HTTP\RequestInterface;

use CodeIgniter\HTTP\ResponseInterface;

use Firebase\JWT\JWT;

use Firebase\JWT\Key;

use Firebase\JWT\ExpiredException;

use Firebase\JWT\SignatureInvalidException;

use UnexpectedValueException;





class AuthFilter implements FilterInterface

{

    /**

     * Do whatever processing this filter needs to do.

     * By default it should not return anything during

     * normal execution. However, when an abnormal state

     * is found, it should return an instance of

     * CodeIgniter\HTTP\Response. If it does, script

     * execution will end and that Response will be

     * sent back to the client, allowing for error pages,

     * redirects, etc.

     *

     * @param RequestInterface $request

     * @param array|null       $arguments

     *

     * @return mixed

     */

    public function before(RequestInterface $request, $arguments = null)

    {

        // $key = $_ENV;

        // echo 'sss';

        // print_r($key); exit;

        $tokenkey = $request->getHeader("Tokenkey");

        $atoken = $request->getHeader("Atoken");

        $token2 = null;

        $key2 = null;

        // extract the token from the header

        if(!empty($atoken)) {

            if (preg_match('/Bearer\s(\S+)/', $atoken, $matches)) {

                $token2 = $matches[1];

            }

        }

        if(!empty($tokenkey)) {

            if (preg_match('/Bearer\s(\S+)/', $tokenkey, $matches)) {

                $key2 = $matches[1];

            }

        }


        // check if token is null or empty

        if(is_null($token2) || empty($token2)) {

            $response = service('response');

            $response->setBody('Access denied');

            $response->setStatusCode(401);

            return $response;

        }

        try {
                $decoded2 = JWT::decode($token2, new Key($key2, 'HS256'));
            } 
            catch (UnexpectedValueException $e) {
                if($e->getMessage() == 'Expired token')
                {
                    $response = service('response');

                    $response->setBody('Access Token Expiry');

                    $response->setStatusCode(401);

                    return $response;
                }
                else
                {

                    $response = service('response');

                    $response->setBody($e->getMessage());

                    $response->setStatusCode(401);

                    return $response;

                }

            } 

    }

  

    /**

     * Allows After filters to inspect and modify the response

     * object as needed. This method does not allow any way

     * to stop execution of other after filters, short of

     * throwing an Exception or Error.

     *

     * @param RequestInterface  $request

     * @param ResponseInterface $response

     * @param array|null        $arguments

     *

     * @return mixed

     */

    public function after(RequestInterface $request, ResponseInterface $response, $arguments = null)

    {

        //

    }

}