<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddOffer extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
            'type' => 'BIGINT',
            'constraint' => 255,
            'unsigned' => true,
            'auto_increment' => true
                        ],
            'offer' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
                    ],
            'status' => [
            'type' => 'INT',
            'constraint' => '11',
                    ],
            'created_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
            'updated_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('tbl_offer');
    }
  
    public function down()
    {
        $this->forge->dropTable('tbl_offer');
    }
}
