<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class AddPlaceOrder extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
            'type' => 'BIGINT',
            'constraint' => 255,
            'unsigned' => true,
            'auto_increment' => true
                        ],
            'cart_session' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'order_code' => [
            'type' => 'VARCHAR',
            'unique' => true,
            'constraint' => '255',
                   ],
            'name' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'mobile' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'email' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'address' => [
            'type' => 'TEXT',
            'null'  => true,
                    ],
            'total_unitprice' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'total_dis' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'total_amount' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null'  => true,
                    ],
            'status' => [
            'type' => 'INT',
            'constraint' => '11',
                    ],
            'created_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
            'updated_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
            'reason' => [
            'type' => 'TEXT',
            'null'  => true,
                    ],
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('tbl_placeorder');
    }
  
    public function down()
    {
        $this->forge->dropTable('tbl_placeorder');
    }
}
