<?php
  
namespace App\Database\Migrations;
  
use CodeIgniter\Database\Migration;
  
class AddUser extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
            'type' => 'BIGINT',
            'constraint' => 255,
            'unsigned' => true,
            'auto_increment' => true
                        ],
            'name' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
                    ],
            'mobile' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
                    ],
            'usertype' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
                    ],
            'email' => [
            'type' => 'VARCHAR',
            'unique' => true,
            'constraint' => '255',
                        ],
            'password' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
                        ],
            'passkey' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
                        ],
            'address' => [
            'type' => 'TEXT',
            'null' => true
                    ],
            'pincode' => [
            'type' => 'VARCHAR',
            'constraint' => '255',
            'null' => true
                    ],
            'state_id' => [
            'type' => 'INT',
            'constraint' => '11',
                   ],
            'token_key' => [
                'type' => 'TEXT',
                        ],
            'status' => [
            'type' => 'INT',
            'constraint' => '11',
                    ],
            'created_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
            'updated_at' => [
            'type' => 'TIMESTAMP',
            'null' => true
                        ],
        ]);
        $this->forge->addPrimaryKey('id');
        $this->forge->createTable('tbl_users');
    }
  
    public function down()
    {
        $this->forge->dropTable('tbl_users');
    }
}