<?php
namespace App\Controllers;
 use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\UserModel;
use App\Models\UserLogoModel;
class User extends BaseController
{
    use ResponseTrait;
     
    public function index()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'limit' => ['rules' => 'required|min_length[1]|numeric'],
                'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
            ];
        if($this->validate($rules)){
            $users = new UserModel;
            try
            {
                $search = $this->request->getPost('search');
                $limit = $this->request->getPost('limit');
                $status = $this->request->getPost('status');
                if($search == ''){
                  $paginateData = $users->select('tbl_users.*,tbl_userroles.role')
                                        ->join('tbl_userroles','tbl_userroles.id=tbl_users.usertype','LEFT')
                                        ->where('tbl_users.status',$status)
                                        ->orderBy('tbl_users.id','asc')
                                        ->paginate($limit);
                }else{
                  $paginateData = $users->select('tbl_users.*,tbl_userroles.role')
                                        ->join('tbl_userroles','tbl_userroles.id=tbl_users.usertype','LEFT')
                                        ->where('tbl_users.status',$status)
                                        ->Like('tbl_users.name', $search)
                                        ->orLike('tbl_users.email', $search)
                                        ->orderBy('tbl_users.id','asc')
                                        ->paginate($limit);
                }
                // if($search == ''){
                //   $paginateData = $users->where('status',$status)->paginate($limit);
                // }else{
                //   $paginateData = $users->select('*')
                //       ->where('status',$status)
                //       ->Like('name', $search)
                //       ->orLike('email', $search)
                //       ->paginate($limit);
                // }
                if(!empty($paginateData))
                {
                    $pager = service('pager');
                    $total = $pager->getTotal();
                    $next = $pager->getNextPageNum();
                    $prev = $pager->getPreviousPageNum();
                    $userdata = [
                          'j_list' => $paginateData,
                          'next_page' => $next,
                          'prev_prev' => $prev,
                          'total' => $total,
                        ];
                }

                if(!empty($userdata))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => [$userdata]], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Get Single Row Details
    public function getSingleDetails()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'id' => ['rules' => 'required|min_length[1]|numeric'],
            ];
        if($this->validate($rules)){
            $model = new UserModel;
            try
            {
                $id = $this->request->getPost('id');
                $data = $model->find($id);
                if(!empty($data))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Update User Details
    public function editUser()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'name' => ['rules' => 'required|min_length[4]|max_length[255]'],
            'mobile' => ['rules' => 'required|min_length[10]'],
            'email' => ['rules' => 'required|min_length[4]|max_length[255]|valid_email'],
            'usertype' => ['rules' => 'required|min_length[1]|numeric'],
            'state_id' => ['rules' => 'required|min_length[1]|numeric'],
            'password' => ['rules' => 'required|min_length[8]|max_length[255]'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
        ];
        if($this->validate($rules)){
            $model = new UserModel;
            $id = $this->request->getPost('id');
            $data = [
                'name'    => $this->request->getPost('name'),
                'usertype'    => $this->request->getPost('usertype'),
                'mobile'    => $this->request->getPost('mobile'),
                'email'    => $this->request->getPost('email'),
                'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
                'passkey' => $this->request->getPost('password'),
                'address'    => $this->request->getPost('address'),
                'pincode'    => $this->request->getPost('pincode'),
                'state_id'    => $this->request->getPost('state_id'),
                'status'    => $this->request->getPost('status'),
            ];
            try {
              $update=$model->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'User Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Update user Status
    public function statusUpdate()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
        ];
        if($this->validate($rules)){
            $model = new UserModel;
            $id = $this->request->getPost('id');
            $data = [
                'status'    => $this->request->getPost('status'),
            ];
            try {
              $update=$model->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Status Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Change user Password
    public function changePassword()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'password' => ['rules' => 'required|min_length[8]|max_length[255]'],
        ];
        if($this->validate($rules)){
            $model = new UserModel;
            $id = $this->request->getPost('id');
            $data = [
                'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
                'passkay' => $this->request->getPost('password'),
            ];
            try {
              $update=$model->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function getLogo()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $model = new UserLogoModel;
        try
        {
            $data = $model->findall();
            if(!empty($data))
            {
                return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
            }
            else
            {
                return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
            }
        }
        catch (\Exception $e) {
          return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
        }
    }
    public function uploadLogo()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'logo' => ['rules' => 'required|min_length[14]'],
            ];
        if($this->validate($rules)){
        $model = new UserLogoModel;
        try
        {
            $getdata = $model->findAll();
            if(!empty($getdata))
            {
                $id = $getdata[0]['id'];
                $data = [
                    'logo'    =>  $this->request->getPost('logo'),
                ];
                try {
                  $update=$model->where('id', $id)->set($data)->update();
                  return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>[],'errors'=>[]], 200);
                }
                catch (\Exception $e) {
                  return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
                }
            }
            else
            {
                $data = [
                    'logo'    =>  $this->request->getPost('logo'),
                    'status'    => 1,
                ];
                try {
                  $insert=$model->insert($data);
                  return $this->respond(['status'=>1,'message' => 'Upload Successfully','data'=>[],'errors'=>[]], 200);
                } 
                catch (\Exception $e) {
                  return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
                } 
            }

        }
        catch (\Exception $e) {
          return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
        }
    }
}