<?php
namespace App\Controllers;
 use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\OrderModel;
class Report extends BaseController
{
    use ResponseTrait;
    public function index()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'start_date' => ['rules' => 'required'],
                'end_date' => ['rules' => 'required'],
            ];
        if($this->validate($rules)){
            $model = new OrderModel;
            try
            {

                $sdate=date("Y-m-d", strtotime($this->request->getPost('start_date')));
                $edate=date("Y-m-d", strtotime($this->request->getPost('end_date')));
                $start_date = $sdate.' 00:00:00';
                $end_date = $edate.' 23:59:59';
                $data =$model->select('tbl_placeorder.*')
                        ->where('tbl_placeorder.created_at >=',$start_date)
                        ->where('tbl_placeorder.created_at <=',$end_date)
                        ->findAll();
                        
                if(!empty($data))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
}