<?php
namespace App\Controllers;
use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\UserModel;
helper('text');
class Register extends BaseController
{
    use ResponseTrait;
    public function index()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'name' => ['rules' => 'required|min_length[4]|max_length[255]'],
            'mobile' => ['rules' => 'required|min_length[10]'],
            'email' => ['rules' => 'required|min_length[4]|max_length[255]|valid_email|is_unique[tbl_users.email]'],
            'password' => ['rules' => 'required|min_length[8]|max_length[255]'],
            'usertype' => ['rules' => 'required|min_length[1]|numeric'],
            // 'state_id' => ['rules' => 'required|min_length[1]|numeric'],
        ];
            // print_r($data);exit;
        if($this->validate($rules)){
            $model = new UserModel();
            $token=random_string('alnum', 64);
            $data = [
                'name'    => $this->request->getPost('name'),
                'usertype'    => $this->request->getPost('usertype'),
                'mobile'    => $this->request->getPost('mobile'),
                'email'    => $this->request->getPost('email'),
                'password' => password_hash($this->request->getPost('password'), PASSWORD_DEFAULT),
                'passkey' => $this->request->getPost('password'),
                'address'    => $this->request->getPost('address'),
                'pincode'    => $this->request->getPost('pincode'),
                // 'state_id'    => $this->request->getPost('state_id'),
                'token_key'    => $token,
                'status'    => 1,

            ];
            try {
              $insert=$model->insert($data);
              return $this->respond(['status'=>1,'message' => 'User Create Successfully','data'=>[],'errors'=>[]], 200);
            } 
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }  
        }else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
             
        }
            
    }
}