<?php
namespace App\Controllers;
 use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\ProductsModel;
use App\Models\CategoryModel;
use App\Models\CartModel;
use App\Models\OfferModel;
use App\Models\OrderModel;
class Products extends BaseController
{
    use ResponseTrait;
    public function index()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");   
        $rules = [
                'limit' => ['rules' => 'required|min_length[1]|numeric'],
                'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
            ];
        if($this->validate($rules)){
            $model = new ProductsModel;
            try
            {
                $search = $this->request->getPost('search');
                $limit = $this->request->getPost('limit');
                $status = $this->request->getPost('status');
                if($search == ''){
                  $paginateData = $model->select('tbl_products.*,tbl_category.category_name')
                                ->join('tbl_category','tbl_category.id=tbl_products.categoryid','LEFT')
                                ->where('tbl_products.status',$status)
                                ->paginate($limit);
                }else{
                  $paginateData = $model->select('tbl_products.*,tbl_category.category_name')
                      ->join('tbl_category','tbl_category.id=tbl_products.categoryid','LEFT')
                      ->where('tbl_products.status',$status)
                      ->Like('tbl_products.name', $search)
                      ->paginate($limit);
                }
                if(!empty($paginateData))
                {
                    $pager = service('pager');
                    $total = $pager->getTotal();
                    $next = $pager->getNextPageNum();
                    $prev = $pager->getPreviousPageNum();
                    $data = [
                          'j_list' => $paginateData,
                          'next_page' => $next,
                          'prev_prev' => $prev,
                          'total' => $total,
                        ];
                }
                if(!empty($data))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => [$data]], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function addProduct()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'name' => ['rules' => 'required|min_length[4]|max_length[255]|is_unique[tbl_products.name]'],
            'category_id' => ['rules' => 'required'],
            'packageName' => ['rules' => 'required'],
            'unitPrice' => ['rules' => 'required'],
            'availableStock' => ['rules' => 'required'],
            'availableStatus' => ['rules' => 'required'],
            'imageUrl' => ['rules' => 'required'],
            'pdttype' => ['rules' => 'required'],
        ];
        if($this->validate($rules)){
            $model = new ProductsModel();
            $data = [
                'name'    => $this->request->getPost('name'),
                'categoryid'    => $this->request->getPost('category_id'),
                'packageName'    => $this->request->getPost('packageName'),
                'unitPrice'    => $this->request->getPost('unitPrice'),
                'availableStock'    => $this->request->getPost('availableStock'),
                'availableStatus'    => $this->request->getPost('availableStatus'),
                'imageUrl'    => $this->request->getPost('imageUrl'),
                'imageUrl2'    => $this->request->getPost('imageUrl2'),
                'pdttype'    => $this->request->getPost('pdttype'),
                'status'    => 1,
            ];
            try {
              $insert=$model->insert($data);
              return $this->respond(['status'=>1,'message' => 'Create Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Get Single Row Details
    public function getSingleDetails()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'id' => ['rules' => 'required|min_length[1]|numeric'],
            ];
        if($this->validate($rules)){
            $model = new ProductsModel;
            try
            {
                $id = $this->request->getPost('id');
                
                $data = $model->find($id);
                if(!empty($data))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function getItemDetails()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'id' => ['rules' => 'required|min_length[1]|numeric'],
            ];
        if($this->validate($rules)){
            $model = new ProductsModel;
            $cmodel = new CategoryModel;
            $cartmodel = new CartModel;
            $ofmodel = new OfferModel;
            try
            {
                $id = $this->request->getPost('id');
                $cart_session = $this->request->getPost('cart_session');
                $data =$model->select('tbl_products.*,tbl_category.category_name')
                    ->join('tbl_category','tbl_category.id=tbl_products.categoryid','LEFT')
                    ->where('tbl_products.id',$id)
                    ->paginate(1);
                if(!empty($data))
                {
                    $pdtData=[];
                    foreach ($data as $pkey => $pvalue) {
                        $offerdata = $ofmodel->select('*')
                                    ->where('status',1)
                                    ->find();

                        if(!empty($offerdata))
                        {
                            $unitPrice =$pvalue['unitPrice'];
                            $pvalue['discountPrice']=0;
                            $offer_per=!empty($offerdata[0]['offer_per'])?$offerdata[0]['offer_per']:0;
                            if($offer_per !=0)
                            {
                                $discountPrice = ((float)$unitPrice * (float)$offer_per)/100;
                            }
                            else
                            {
                                $discountPrice =0;
                            }
                            $pvalue['discountPrice']=$discountPrice;
                            $sellingPrice =$unitPrice - $discountPrice;
                            $pvalue['sellingPrice']=$sellingPrice;
                        }
                        $pvalue['cart_qty']='';
                        $pvalue['cart_total']='';
                        $cartData = $cartmodel->select('*')
                                    ->where('product_id',$pvalue['id'])
                                    ->where('cart_session',$cart_session)
                                    ->where('status',1)
                                    ->find();

                        if(!empty($cartData))
                        {
                            $pvalue['cart_qty']=$cartData[0]['qty'];
                            $pvalue['cart_total']=$cartData[0]['total'];
                        }
                        array_push($pdtData, $pvalue);
                    }
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $pdtData], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Update category Details
    public function editProduct()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'name' => ['rules' => 'required|min_length[4]|max_length[255]'],
            'category_id' => ['rules' => 'required'],
            'packageName' => ['rules' => 'required'],
            'unitPrice' => ['rules' => 'required'],
            'availableStock' => ['rules' => 'required'],
            'availableStatus' => ['rules' => 'required'],
            'imageUrl' => ['rules' => 'required'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
            'pdttype' => ['rules' => 'required'],
        ];
        if($this->validate($rules)){
            $model = new ProductsModel;
            $id = $this->request->getPost('id');
            $data = [
                'name'    => $this->request->getPost('name'),
                'categoryid'    => $this->request->getPost('category_id'),
                'packageName'    => $this->request->getPost('packageName'),
                'unitPrice'    => $this->request->getPost('unitPrice'),
                'availableStock'    => $this->request->getPost('availableStock'),
                'availableStatus'    => $this->request->getPost('availableStatus'),
                'imageUrl'    => $this->request->getPost('imageUrl'),
                'imageUrl2'    => $this->request->getPost('imageUrl2'),
                'pdttype'    => $this->request->getPost('pdttype'),
                'status'    => $this->request->getPost('status'),
            ];
            try {
              $update=$model->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    //Update category Status
    public function statusUpdate()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
        ];
        if($this->validate($rules)){
            $model = new ProductsModel;
            $id = $this->request->getPost('id');
            $data = [
                'status'    => $this->request->getPost('status'),
            ];
            try {
              $update=$model->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function getCategoryPdts()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'limit' => ['rules' => 'required|min_length[1]|numeric'],
                'cart_session' => ['rules' => 'required'],
            ];

        if($this->validate($rules)){
            $pmodel = new ProductsModel;
            $cmodel = new CategoryModel;
            $cartmodel = new CartModel;
            $ofmodel = new OfferModel;
            try
            {
                $category_id = $this->request->getPost('category_id');
                $cart_session = $this->request->getPost('cart_session');
                $limit = $this->request->getPost('limit');
                if($category_id !='')
                {
                    $productData = $pmodel->select('tbl_products.*,tbl_category.category_name')
                                    ->join('tbl_category','tbl_category.id=tbl_products.categoryid','LEFT')
                                    ->where('tbl_products.categoryid',$category_id)
                                    ->where('tbl_products.availableStatus','A')
                                    ->where('tbl_products.availableStock !=','0')
                                    ->paginate($limit);
                }
                else
                {
                    $productData = $pmodel->select('tbl_products.*,tbl_category.category_name')
                                    ->join('tbl_category','tbl_category.id=tbl_products.categoryid','LEFT')
                                    ->where('tbl_products.availableStatus','A')
                                    ->where('tbl_products.availableStock !=','0')
                                    ->paginate($limit);
                }
                if(!empty($productData))
                {
                    $pdtData=[];
                    foreach ($productData as $pkey => $pvalue) {
                        $offerdata = $ofmodel->select('*')
                                    ->where('status',1)
                                    ->find();

                        if(!empty($offerdata))
                        {
                            $unitPrice =$pvalue['unitPrice'];
                            $pvalue['discountPrice']=0;
                            $offer_per=!empty($offerdata[0]['offer_per'])?$offerdata[0]['offer_per']:0;
                            if($offer_per !=0)
                            {
                                $discountPrice = ((float)$unitPrice * (float)$offer_per)/100;
                            }
                            else
                            {
                                $discountPrice =0;
                            }
                            $pvalue['discountPrice']=$discountPrice;
                            $sellingPrice =$unitPrice - $discountPrice;
                            $pvalue['sellingPrice']=$sellingPrice;
                        }
                        $pvalue['cart_qty']='';
                        $pvalue['cart_total']='';
                        $cartData = $cartmodel->select('*')
                                    ->where('product_id',$pvalue['id'])
                                    ->where('cart_session',$cart_session)
                                    ->where('status',1)
                                    ->find();

                        if(!empty($cartData))
                        {
                            $pvalue['cart_qty']=$cartData[0]['qty'];
                            $pvalue['cart_total']=$cartData[0]['total'];
                        }
                        array_push($pdtData, $pvalue);
                    }
                    $pager = service('pager');
                    $total = $pager->getTotal();
                    $next = $pager->getNextPageNum();
                    $prev = $pager->getPreviousPageNum();
                    $data = [
                          'j_list' => $pdtData,
                          'next_page' => $next,
                          'prev_prev' => $prev,
                          'total' => $total,
                        ];
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
                    
                }
                else
                {
                    return $this->respond(['status'=>0,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function bestSellingPdts()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'cart_session' => ['rules' => 'required'],
            ];

        if($this->validate($rules)){
            $pmodel = new ProductsModel;
            $cmodel = new CategoryModel;
            $cartmodel = new CartModel;
            $ofmodel = new OfferModel;
            try
            {
                $category_id = $this->request->getPost('category_id');
                $cart_session = $this->request->getPost('cart_session');
                $productData = $pmodel->select('tbl_products.*,tbl_category.category_name')
                                    ->join('tbl_category','tbl_category.id=tbl_products.categoryid','LEFT')
                                    ->where('tbl_products.availableStatus','A')
                                    ->where('tbl_products.availableStock !=','0')
                                    ->where('tbl_products.pdttype','best')
                                    ->orderBy('tbl_products.created_at')
                                    ->paginate(8);
                if(!empty($productData))
                {
                    $pdtData=[];
                    foreach ($productData as $pkey => $pvalue) {
                        $offerdata = $ofmodel->select('*')
                                    ->where('status',1)
                                    ->find();

                        if(!empty($offerdata))
                        {
                            $unitPrice =$pvalue['unitPrice'];
                            $pvalue['discountPrice']=0;
                            $offer_per=!empty($offerdata[0]['offer_per'])?$offerdata[0]['offer_per']:0;
                            if($offer_per !=0)
                            {
                                $discountPrice = ((float)$unitPrice * (float)$offer_per)/100;
                            }
                            else
                            {
                                $discountPrice =0;
                            }
                            $pvalue['discountPrice']=$discountPrice;
                            $sellingPrice =$unitPrice - $discountPrice;
                            $pvalue['sellingPrice']=$sellingPrice;
                        }
                        $pvalue['cart_qty']='';
                        $pvalue['cart_total']='';
                        $cartData = $cartmodel->select('*')
                                    ->where('product_id',$pvalue['id'])
                                    ->where('cart_session',$cart_session)
                                    ->where('status',1)
                                    ->find();

                        if(!empty($cartData))
                        {
                            $pvalue['cart_qty']=$cartData[0]['qty'];
                            $pvalue['cart_total']=$cartData[0]['total'];
                        }
                        array_push($pdtData, $pvalue);
                    }
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $pdtData], 200);
                }
                else
                {
                    return $this->respond(['status'=>0,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function newArrivePdts()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'cart_session' => ['rules' => 'required'],
            ];

        if($this->validate($rules)){
            $pmodel = new ProductsModel;
            $cmodel = new CategoryModel;
            $cartmodel = new CartModel;
            $ofmodel = new OfferModel;
            try
            {
                $category_id = $this->request->getPost('category_id');
                $cart_session = $this->request->getPost('cart_session');
                $productData = $pmodel->select('tbl_products.*,tbl_category.category_name')
                                    ->join('tbl_category','tbl_category.id=tbl_products.categoryid','LEFT')
                                    ->where('tbl_products.availableStatus','A')
                                    ->where('tbl_products.availableStock !=','0')
                                    ->where('tbl_products.pdttype','new')
                                    ->orderBy('tbl_products.created_at')
                                    ->paginate(8);
                if(!empty($productData))
                {
                    $pdtData=[];
                    foreach ($productData as $pkey => $pvalue) {
                        $offerdata = $ofmodel->select('*')
                                    ->where('status',1)
                                    ->find();

                        if(!empty($offerdata))
                        {
                            $unitPrice =$pvalue['unitPrice'];
                            $pvalue['discountPrice']=0;
                            $offer_per=!empty($offerdata[0]['offer_per'])?$offerdata[0]['offer_per']:0;
                            if($offer_per !=0)
                            {
                                $discountPrice = ((float)$unitPrice * (float)$offer_per)/100;
                            }
                            else
                            {
                                $discountPrice =0;
                            }
                            $pvalue['discountPrice']=$discountPrice;
                            $sellingPrice =$unitPrice - $discountPrice;
                            $pvalue['sellingPrice']=$sellingPrice;
                        }
                        $pvalue['cart_qty']='';
                        $pvalue['cart_total']='';
                        $cartData = $cartmodel->select('*')
                                    ->where('product_id',$pvalue['id'])
                                    ->where('cart_session',$cart_session)
                                    ->where('status',1)
                                    ->find();

                        if(!empty($cartData))
                        {
                            $pvalue['cart_qty']=$cartData[0]['qty'];
                            $pvalue['cart_total']=$cartData[0]['total'];
                        }
                        array_push($pdtData, $pvalue);
                    }
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $pdtData], 200);
                }
                else
                {
                    return $this->respond(['status'=>0,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function addCartItems()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'id' => ['rules' => 'required|min_length[1]|numeric'],
                'qty' => ['rules' => 'required'],
                'cart_session' => ['rules' => 'required'],
            ];

        if($this->validate($rules)){
            $cmodel = new CartModel;
            $pmodel = new ProductsModel;
            $ofmodel = new OfferModel;
            try
            {
                $id = $this->request->getPost('id');
                $qty = $this->request->getPost('qty');
                $cart_session = $this->request->getPost('cart_session');
                $productData=$pmodel->select('*')->where('id',$id)->find();
                $packageName=$productData[0]['packageName'];
                $unitPrice=$productData[0]['unitPrice'];
                $offerdata = $ofmodel->select('*')
                                    ->where('status',1)
                                    ->find();

                if(!empty($offerdata))
                {
                    $offer_per=!empty($offerdata[0]['offer_per'])?$offerdata[0]['offer_per']:0;
                    if($offer_per !=0)
                    {
                        $discountPrice = ((float)$unitPrice * (float)$offer_per)/100;
                    }
                    else
                    {
                        $discountPrice =0;
                    }
                    $sellingPrice =$unitPrice - $discountPrice;
                }
                $cartData=$cmodel->select('*')
                        ->where('product_id',$id)
                        ->where('cart_session',$cart_session)
                        ->where('status',1)
                        ->find();
                if($qty =='empty')
                {
                    if(!empty($cartData))
                    {
                        $cartid=$cartData[0]['id'];
                        $delete = $cmodel->delete($cartid);
                    }
                }
                else
                {
                    $total =(float)$qty * (float)$sellingPrice;
                    $totunitPrice =(float)$qty * (float)$unitPrice;
                    $totdiscountPrice =(float)$qty * (float)$discountPrice;
                    $data=[
                            'cart_session'=>$cart_session,
                            'product_id'=>$id,
                            'packageName'=>$packageName,
                            'unitPrice'=>$unitPrice,
                            'discountPrice'=>$discountPrice,
                            'sellingPrice'=>$sellingPrice,
                            'qty'=>$qty,
                            'totunitPrice'=>$totunitPrice,
                            'totdiscountPrice'=>$totdiscountPrice,
                            'total'=>$total,
                            'status'=>1
                        ];
                    if(!empty($cartData))
                    {
                        $cartid=$cartData[0]['id'];
                        $update = $cmodel->where('id', $cartid)->set($data)->update();
                    }
                    else
                    {
                        $insert=$cmodel->insert($data);
                    }
                }
                
                $cartAllData=$cmodel->select('COUNT(id) as total_cart,SUM(totunitPrice) as total_unitprice, SUM(qty) as total_qty,SUM(totdiscountPrice) as total_dis,SUM(total) as total_amount,')->where('cart_session',$cart_session)->where('status',1)->findAll();
                return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>$cartAllData,'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function cartTotalDetails()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'cart_session' => ['rules' => 'required'],
            ];
        if($this->validate($rules)){
            $cmodel = new CartModel;
            try
            {
                $cart_session = $this->request->getPost('cart_session');
                $cartAllData=$cmodel->select('COUNT(id) as total_cart, SUM(totunitPrice) as total_unitprice,SUM(totdiscountPrice) as total_dis, SUM(qty) as total_qty,SUM(total) as total_amount,')
                ->where('cart_session',$cart_session)
                ->where('status',1)
                ->findAll();
                if(!empty($cartAllData))
                {
                    return $this->respond(['status'=>1,'message' => 'Success','data'=>$cartAllData,'errors'=>[]], 200);
                }
                else
                {
                    return $this->respond(['status'=>0,'message' => 'Not Found','data'=>[],'errors'=>[]], 200);
                }
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function getCartPdts()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'cart_session' => ['rules' => 'required'],
            ];

        if($this->validate($rules)){
            $cartmodel = new CartModel;
            $ofmodel = new OfferModel;
            try
            {
                $cart_session = $this->request->getPost('cart_session');
                $cartData = $cartmodel->select('tbl_cart_items.id as cartid,tbl_cart_items.cart_session,tbl_cart_items.qty,tbl_products.*')
                                    ->join('tbl_products','tbl_products.id=tbl_cart_items.product_id','LEFT')
                                    ->where('tbl_cart_items.cart_session',$cart_session)
                                    ->where('tbl_cart_items.status',1)
                                    ->findAll();
                if(!empty($cartData))
                {
                    $pdtData=[];
                    foreach ($cartData as $pkey => $pvalue) {
                        $offerdata = $ofmodel->select('*')
                                    ->where('status',1)
                                    ->find();

                        if(!empty($offerdata))
                        {
                            $unitPrice =$pvalue['unitPrice'];
                            $pvalue['discountPrice']=0;
                            $offer_per=!empty($offerdata[0]['offer_per'])?$offerdata[0]['offer_per']:0;
                            $minimum_order=!empty($offerdata[0]['minimum_order'])?$offerdata[0]['minimum_order']:0;
                            if($offer_per !=0)
                            {
                                $discountPrice = ((float)$unitPrice * (float)$offer_per)/100;
                            }
                            else
                            {
                                $discountPrice =0;
                            }
                            $pvalue['discountPrice']=$discountPrice;
                            $sellingPrice =$unitPrice - $discountPrice;
                            $pvalue['sellingPrice']=$sellingPrice;
                            $pvalue['minimum_order']=$minimum_order;
                        }
                        array_push($pdtData, $pvalue);
                    }
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $pdtData], 200);
                    
                }
                else
                {
                    return $this->respond(['status'=>0,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function getCartDelete()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'id' => ['rules' => 'required'],
            ];
        if($this->validate($rules)){
            $cmodel = new CartModel;
            try
            {
                $id = $this->request->getPost('id');
                $delete = $cmodel->delete($id);
                return $this->respond(['status'=>1,'message' => 'Success','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function placeOrder()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'cart_session' => ['rules' => 'required'],
                'name' => ['rules' => 'required'],
                'mobile' => ['rules' => 'required'],
                'email' => ['rules' => 'required'],
                'address' => ['rules' => 'required'],
                'pincode' => ['rules' => 'required'],
            ];

        if($this->validate($rules)){
            $cmodel = new CartModel;
            $omodel = new OrderModel;
            $pmodel = new ProductsModel;
            try
            {
                $name = $this->request->getPost('name');
                $mobile = $this->request->getPost('mobile');
                $alter_mobile = $this->request->getPost('alter_mobile');
                $email = $this->request->getPost('email');
                $address = $this->request->getPost('address');
                $pincode = $this->request->getPost('pincode');
                $minimum_order = $this->request->getPost('minimum_order');
                $cart_session = $this->request->getPost('cart_session');
                $cartAllData=$cmodel->select('COUNT(id) as total_cart, SUM(totunitPrice) as total_unitprice,SUM(totdiscountPrice) as total_dis, SUM(qty) as total_qty,SUM(total) as total_amount,')->where('cart_session',$cart_session)->where('status',1)->findAll();
                if(!empty($cartAllData))
                {
                    $total_unitprice=$cartAllData[0]['total_unitprice'];
                    $total_dis=$cartAllData[0]['total_dis'];
                    $total_amount=$cartAllData[0]['total_amount'];
                   
                    if((float)$total_amount >= (float)$minimum_order)
                    {
                        $lastid = $omodel->select('id')
                        ->orderBy('id', 'desc')
                        ->paginate(1);
                        $uKey='SC-';
                        if(!empty($lastid))
                        {
                            $nextId=$lastid[0]['id'] + 1;
                            $uCode=$uKey.sprintf('%02d',$nextId);
                        }
                        else
                        {
                            $uCode=$uKey.sprintf('%02d',2000);
                        }
                        $data=[
                                'cart_session'=>$cart_session,
                                'order_code' => $uCode,
                                'name'=>$name,
                                'mobile'=>$mobile,
                                'alter_mobile'=>$alter_mobile,
                                'email'=>$email,
                                'address'=>$address,
                                'pincode'=>$pincode,
                                'total_unitprice'=>$total_unitprice,
                                'total_dis'=>$total_dis,
                                'total_amount'=>$total_amount,
                                'status'=>1
                            ];
                        $insert=$omodel->insert($data);
                        $updata=['status'=>2];
                        $update = $cmodel->where('cart_session', $cart_session)->set($updata)->update();
                        $cartData = $cmodel->select('tbl_cart_items.qty,tbl_products.*')
                                        ->join('tbl_products','tbl_products.id=tbl_cart_items.product_id','LEFT')
                                        ->where('tbl_cart_items.cart_session',$cart_session)
                                        ->where('tbl_cart_items.status',1)
                                        ->findAll();
                        $pdtupdata=[];
                        foreach ($cartData as $key => $value) {
                            $id=$value['id'];
                            $qty=$value['qty'];
                            $availableStock=$value['availableStock'];
                            $stoctreduce =(int)$availableStock - (int)$qty;
                            $availableStatus ='A';
                            if($stoctreduce <=0)
                            {
                                $availableStatus ='O';
                                $stoctreduce=0;
                            }
                            $data=[
                                'id'=>$id,
                                'availableStock'=>$stoctreduce,
                                'availableStatus'=>$availableStatus
                            ];
                            array_push($pdtupdata,$data);
                        }
                        $updatestock= $pmodel->updateBatch($pdtupdata,'id');
                        return $this->respond(['status'=>1,'message' => 'Order Placed Successfully','data'=>$insert,'errors'=>[]], 200);
                    }
                    else
                    {
                        return $this->respond(['status'=>0,'message' => "Minimum Order value greater then 2000 rupees!",'data'=>[],'errors'=>[]], 200);   
                    }
                }
                else
                {
                    return $this->respond(['status'=>0,'message' => "Cart Item Missing",'data'=>[],'errors'=>[]], 200);   
                }
                
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
}