<?php
namespace App\Controllers;
 use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\ProductsModel;
use App\Models\CategoryModel;
use App\Models\CartModel;
use App\Models\OrderModel;
class Order extends BaseController
{
    use ResponseTrait;
    public function index()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'limit' => ['rules' => 'required|min_length[1]|numeric'],
                'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
            ];
        if($this->validate($rules)){
            $model = new OrderModel;
            try
            {
                $search = $this->request->getPost('search');
                $limit = $this->request->getPost('limit');
                $status = $this->request->getPost('status');
                if($search == ''){
                  $paginateData = $model->select('tbl_placeorder.*')
                                        ->where('tbl_placeorder.status',$status)
                                        ->orderBy('tbl_placeorder.created_at','desc')
                                        ->paginate($limit);
                }else{
                  $paginateData = $model->select('tbl_placeorder.*')
                                        ->Like('tbl_placeorder.order_code', $search)
                                        ->orLike('tbl_placeorder.mobile', $search)
                                        ->where('tbl_placeorder.status',$status)
                                        ->orderBy('tbl_placeorder.created_at','desc')
                                        ->paginate($limit);
                }
                if(!empty($paginateData))
                {
                    $pager = service('pager');
                    $total = $pager->getTotal();
                    $next = $pager->getNextPageNum();
                    $prev = $pager->getPreviousPageNum();
                    $data = [
                          'j_list' => $paginateData,
                          'next_page' => $next,
                          'prev_prev' => $prev,
                          'total' => $total,
                        ];
                }
                if(!empty($data))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => [$data]], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function getOderDetails()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'orderid' => ['rules' => 'required'],
            ];

        if($this->validate($rules)){
            $omodel = new OrderModel;
            $cmodel = new CartModel;
            try
            {
                $orderid = $this->request->getPost('orderid');
                $orderData = $omodel->select('tbl_placeorder.*')
                                    ->where('tbl_placeorder.id',$orderid)
                                    ->findAll();
                
                if(!empty($orderData))
                {
                    $alldata=[];
                    foreach ($orderData as $key => $value) {
                        $value['items']=[];
                        $cartData = $cmodel->select('tbl_cart_items.*,tbl_products.name,tbl_products.imageUrl,tbl_products.categoryid')
                                    ->join('tbl_products','tbl_products.id=tbl_cart_items.product_id','LEFT')
                                    ->where('tbl_cart_items.cart_session',$value['cart_session'])
                                    ->where('tbl_cart_items.status',2)
                                    ->orderBy('tbl_products.categoryid','asc')
                                    ->findAll();
                        if(!empty($cartData))
                        {
                            $value['items']=$cartData;
                        }
                        array_push($alldata, $value);
                    }
                    
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $alldata], 200);
                    
                }
                else
                {
                    return $this->respond(['status'=>0,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function statusUpdate()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
        ];
        if($this->validate($rules)){
            $model = new ProductsModel;
            $omodel = new OrderModel;
            $id = $this->request->getPost('id');
            $reason = $this->request->getPost('reason');
            $status = $this->request->getPost('status');
            $data = [
                'status'    => $status,
                'reason'    => $reason
            ];
            try {
              $update=$omodel->where('id', $id)->set($data)->update();
              if($status == 3)
              {
                 $orderItemData = $omodel->select('tbl_cart_items.*,tbl_products.availableStock')
                                    ->join('tbl_cart_items','tbl_cart_items.cart_session=tbl_placeorder.cart_session','LEFT')
                                    ->join('tbl_products','tbl_products.id=tbl_cart_items.product_id','LEFT')
                                    ->where('tbl_placeorder.id',$id)
                                    ->findAll();
                $updata=[];
                 if(!empty($orderItemData))
                 {
                    foreach($orderItemData as $key => $value) {
                        $stockval = (float)$value['availableStock'] + (float)$value['qty'];
                        $data=[
                            'id'=>$value['product_id'],
                            'availableStock'=>$stockval,
                        ];
                        array_push($updata,$data);
                    }
                 }
                 $updatestock= $model->updateBatch($updata,'id');
              }
              return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function uploadPayDetails()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'paymentimage' => ['rules' => 'required'],
        ];
        if($this->validate($rules)){
            $omodel = new OrderModel;
            $id = $this->request->getPost('id');
            $paymentimage = $this->request->getPost('paymentimage');
            $data = [
                'paymentimage'    => $paymentimage,
                'verify_status' =>1
            ];
            try {
              $update=$omodel->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Submit Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function payStatusUpdate()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
        ];
        if($this->validate($rules)){
            $model = new ProductsModel;
            $omodel = new OrderModel;
            $id = $this->request->getPost('id');
            $status = $this->request->getPost('status');
            $data = [
                'verify_status'    => $status,
            ];
            try {
              $update=$omodel->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
}