<?php
namespace App\Controllers;
use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\OfferModel;
class Offer extends BaseController
{
    use ResponseTrait;
    
    public function addOffer()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'offer' => ['rules' => 'required'],
        ];
            // print_r($data);exit;
        if($this->validate($rules)){
            $model = new OfferModel();
            $data = [
                'offer'    => $this->request->getPost('offer'),
                'offer_per'    => $this->request->getPost('offer_per'),
                'minimum_order'    => $this->request->getPost('minimum_order'),
                'status'    => 1,

            ];
            try {
              $insert=$model->insert($data);
              return $this->respond(['status'=>1,'message' => 'Offer Create Successfully','data'=>[],'errors'=>[]], 200);
            } 
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }  
        }else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
             
        }
            
    }
    //Get Single Row Details
    public function getSingleDetails()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
                'id' => ['rules' => 'required|min_length[1]|numeric'],
            ];
        if($this->validate($rules)){
            $model = new OfferModel;
            try
            {
                $id = $this->request->getPost('id');
                $data = $model->find($id);
                if(!empty($data))
                {
                    return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
                }
                else
                {
                    return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
                }

            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else
        {
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function editOffer()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $rules = [
            'id' => ['rules' => 'required|min_length[1]|numeric'],
            'offer' => ['rules' => 'required'],
            'status' => ['rules' => 'required|numeric|min_length[1]|max_length[1]'],
        ];
        if($this->validate($rules)){
            $model = new OfferModel;
            $id = $this->request->getPost('id');
            $data = [
                'offer'    => $this->request->getPost('offer'),
                'offer_per'    => $this->request->getPost('offer_per'),
                'minimum_order'    => $this->request->getPost('minimum_order'),
                'status'    => $this->request->getPost('status'),
            ];
            try {
              $update=$model->where('id', $id)->set($data)->update();
              return $this->respond(['status'=>1,'message' => 'Offer Update Successfully','data'=>[],'errors'=>[]], 200);
            }
            catch (\Exception $e) {
              return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
            }
        }
        else{
            $response = [
                'status'=>0,
                'errors' => $this->validator->getErrors(),
                'message' => 'Invalid Inputs',
                'data'=>[]
            ];
            return $this->respond($response , 200);
        }
    }
    public function getSingleData()
    {
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $model = new OfferModel;
        try
        {
            $data = $model->select('*')
                          ->where('status',1)
                          ->paginate(1);
            if(!empty($data))
            {
                return $this->respond(['status'=>1,'message' => "Sussess",'data' => $data], 200);
            }
            else
            {
                return $this->respond(['status'=>1,'message' => "Not Found",'data' => []], 200);
            }

        }
        catch (\Exception $e) {
          return $this->respond(['status'=>0,'message' => $e->getMessage(),'data'=>[],'errors'=>[]], 200);
        }
    }
}