<?php
  
namespace App\Controllers;
  
use App\Controllers\BaseController;
use CodeIgniter\API\ResponseTrait;
use App\Models\UserModel;
use \Firebase\JWT\JWT;

class Login extends BaseController
{
    use ResponseTrait;
      
    public function index()
    {
        // Origin
        header('Access-Control-Allow-Origin: *');
        header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
        header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
        $userModel = new UserModel();
   
        $email = $this->request->getPost('email');
        $password = $this->request->getPost('password');
           
        $user = $userModel->where('email', $email)->first();
        
        if(is_null($user)) {
            return $this->respond(['status' => 0,'message' => 'Invalid username.','data' => [],'errors' => []], 200);
        }
   
        $pwd_verify = password_verify($password, $user['password']);
        
        if(!$pwd_verify) {
            return $this->respond(['status' => 0,'message' => 'Invalid username or password.','data' => [],'errors' => []], 200);
        }

        $key2 = $user['token_key'];
        $iat = time(); // current timestamp value
        $exp = $iat + 14400;
        $payload = array(
            "iss" => "Issuer of the JWT",
            "aud" => "Audience that the JWT",
            "sub" => "Subject of the JWT",
            "iat" => $iat, //Time the JWT issued at
            "exp" => $exp, // Expiration time of token
            "email" => $user['email'],
        );
        try
        {
            $atoken = JWT::encode($payload, $key2, 'HS256');
            $data =["id"=>$user['id'],
                    "name"      => $user['name'],
                    "mobile"    => $user['mobile'],
                    "state_id"  => $user['state_id'],
                    "usertype"  => $user['usertype'],
                    "token_key" => $user['token_key'],
                    "atoken"    => $atoken,
                    ];
            // print_r($data);exit;
            $response = [
                'status' => 1,
                'message' => 'Login Successful',
                'data' => [$data],
                'errors' => [],
            ];
              
            return $this->respond($response, 200);
        }catch(\Exception $e)
        {
            return $this->respond(['status' => 0,'message' => $e->getMessage(),'data' => [],'errors' => []], 200);
        }
    }
  
}