<?php



namespace Config;



// Create a new instance of our RouteCollection class.

$routes = Services::routes();



// Load the system's routing file first, so that the app and ENVIRONMENT

// can override as needed.

if (is_file(SYSTEMPATH . 'Config/Routes.php')) {

    require SYSTEMPATH . 'Config/Routes.php';

}



/*

 * --------------------------------------------------------------------

 * Router Setup

 * --------------------------------------------------------------------

 */

$routes->setDefaultNamespace('App\Controllers');

$routes->setDefaultController('Home');

$routes->setDefaultMethod('index');

$routes->setTranslateURIDashes(false);

$routes->set404Override();

// The Auto Routing (Legacy) is very dangerous. It is easy to create vulnerable apps

// where controller filters or CSRF protection are bypassed.

// If you don't want to define all routes, please use the Auto Routing (Improved).

// Set `$autoRoutesImproved` to true in `app/Config/Feature.php` and set the following to true.

// $routes->setAutoRoute(false);



/*

 * --------------------------------------------------------------------

 * Route Definitions

 * --------------------------------------------------------------------

 */



// We get a performance increase by specifying the default

// route since we don't have to scan directories.

$routes->get('/', 'Home::index');



/*

 * --------------------------------------------------------------------

 * Additional Routing

 * --------------------------------------------------------------------

 *

 * There will often be times that you need additional routing and you

 * need it to be able to override any defaults in this file. Environment

 * based routes is one such time. require() additional route files here

 * to make that happen.

 *

 * You will have access to the $routes object within that file without

 * needing to reload it.

 */

 //User Route

$routes->group("api/user", function ($routes) {

    $routes->post("create", "Register::index");

    $routes->post("login", "Login::index");

    $routes->post("list", "User::index", ['filter' => 'authFilter']);

    $routes->post("get_details", "User::getSingleDetails", ['filter' => 'authFilter']);

    $routes->post("edit", "User::editUser", ['filter' => 'authFilter']);

    $routes->post("status_update", "User::statusUpdate", ['filter' => 'authFilter']);

    $routes->post("change_password", "User::changePassword", ['filter' => 'authFilter']);

    $routes->get("getlogo", "User::getLogo", ['filter' => 'authFilter']);

    $routes->post("uploadlogo", "User::uploadLogo", ['filter' => 'authFilter']);

});

$routes->group("api/products", function ($routes) {

    $routes->post("get_catepdts", "Products::getCategoryPdts");
    $routes->post("newarrivepdt", "Products::newArrivePdts");
    $routes->post("bestsellpdt", "Products::bestSellingPdts");
    $routes->post("add_cart", "Products::addCartItems");
    $routes->post("cart_total", "Products::cartTotalDetails");
    $routes->post("cart_items", "Products::getCartPdts");
    $routes->post("cart_delete", "Products::getCartDelete");
    $routes->post("place_order", "Products::placeOrder");
    $routes->post("getdetails", "Products::getItemDetails");

    $routes->post("list", "Products::index", ['filter' => 'authFilter']);
    
    $routes->post("create", "Products::addProduct", ['filter' => 'authFilter']);

    $routes->post("get_details", "Products::getSingleDetails", ['filter' => 'authFilter']);

    $routes->post("edit", "Products::editProduct", ['filter' => 'authFilter']);

    $routes->post("status_update", "Products::statusUpdate", ['filter' => 'authFilter']);

});

$routes->group("api/order", function ($routes) {

    $routes->post("list", "Order::index", ['filter' => 'authFilter']);

    $routes->post("get_order", "Order::getOderDetails", ['filter' => 'authFilter']);
    
    $routes->post("status_update", "Order::statusUpdate", ['filter' => 'authFilter']);

    $routes->post("get_order_pdf", "Order::getOderDetails");

    $routes->post("upload_paydetail", "Order::uploadPayDetails");

    $routes->post("pay_status_update", "Order::payStatusUpdate", ['filter' => 'authFilter']);

});

$routes->group("api/category", function ($routes) {

    $routes->post("list", "Category::index", ['filter' => 'authFilter']);

    $routes->post("all", "Category::allList", ['filter' => 'authFilter']);

    $routes->post("create", "Category::addCategory", ['filter' => 'authFilter']);

    $routes->post("get_details", "Category::getSingleDetails", ['filter' => 'authFilter']);

    $routes->post("edit", "Category::editCategory", ['filter' => 'authFilter']);

    $routes->post("status_update", "Category::statusUpdate", ['filter' => 'authFilter']);

    $routes->get("get_singledata", "Category::getSingleData");

    $routes->post("alllist", "Category::allList");

});
$routes->group("api/dashboard", function ($routes) {

    $routes->get("count", "Dashboard::index", ['filter' => 'authFilter']);
});
 //Offer Route

$routes->group("api/offer", function ($routes) {

    $routes->post("create", "Offer::addOffer", ['filter' => 'authFilter']);

    $routes->post("get_details", "Offer::getSingleDetails", ['filter' => 'authFilter']);

    $routes->get("singledata", "Offer::getSingleData", ['filter' => 'authFilter']);

    $routes->post("edit", "Offer::editOffer", ['filter' => 'authFilter']);

    $routes->get("singledatanew", "Offer::getSingleData");


});
$routes->group("api/report", function ($routes) {

    $routes->post("order_report", "Report::index", ['filter' => 'authFilter']);

});
if (is_file(APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php')) {

    require APPPATH . 'Config/' . ENVIRONMENT . '/Routes.php';

}

